<?php
// Return if no toggle box to show
if ( empty( $boxes ) )
	return;

// Add Open only one class
$groupclass = ( $onlyone ) ? 'toggle-onlyone' : '';

// Set vars
$subtitle = ( !empty( $subtitle ) ) ? $subtitle : '';
?>

<div class="hootkit-toggle-wrap">

	<?php
	/* Display Title */
	$titlemarkup = $titleclass = '';
	if ( !empty( $title ) ) {
		$titlemarkup .= $before_title . $title . $after_title;
		$titleclass .= ' hastitle';
	}
	$titlemarkup = ( !empty( $titlemarkup ) ) ? '<div class="widget-title-wrap' . $titleclass . '">' . $titlemarkup . '</div>' : '';
	$titlemarkup .= ( !empty( $subtitle ) ) ? '<div class="widget-subtitle hoot-subtitle">' . $subtitle . '</div>' : '';
	echo do_shortcode( wp_kses_post( apply_filters( 'hootkit_widget_title', $titlemarkup, 'toggle', $title, $before_title, $after_title, $subtitle ) ) );
	?>

	<div class="hootkit-toggle <?php echo $groupclass ?>">
		<?php
		foreach ( $boxes as $key => $box ) {
			$unitclass = ( !empty( $box['open'] ) ) ? 'hootkit-toggle-active' : '';
			$boxclass = ( !empty( $box['open'] ) ) ? 'default-open' : '';
			echo '<div class="hootkit-toggle-unit ' . $unitclass . '">';
				echo '<div class="hootkit-toggle-head"><i class="fas"></i>' . do_shortcode( wp_kses_post( $box['title'] ) ) . '</div>';
				echo '<div class="hootkit-toggle-box ' . $boxclass . '">' . do_shortcode( wp_kses_post( wpautop( $box['content'] ) ) ) . '</div>';
			echo '</div>';
		}
		?>
	</div>

</div>