<?php
// Return if no tab boxes to show
if ( empty( $boxes ) )
	return;

// Set vars
$subtitle = ( !empty( $subtitle ) ) ? $subtitle : '';
?>

<div class="hootkit-tabs-wrap">

	<?php
	/* Display Title */
	$titlemarkup = $titleclass = '';
	if ( !empty( $title ) ) {
		$titlemarkup .= $before_title . $title . $after_title;
		$titleclass .= ' hastitle';
	}
	$titlemarkup = ( !empty( $titlemarkup ) ) ? '<div class="widget-title-wrap' . $titleclass . '">' . $titlemarkup . '</div>' : '';
	$titlemarkup .= ( !empty( $subtitle ) ) ? '<div class="widget-subtitle hoot-subtitle">' . $subtitle . '</div>' : '';
	echo do_shortcode( wp_kses_post( apply_filters( 'hootkit_widget_title', $titlemarkup, 'tabs', $title, $before_title, $after_title, $subtitle ) ) );
	?>

	<div class="hootkit-tabs">
		<div class="hootkit-tabheads">
			<?php
			$current = 'current-tabhead';
			$count = 1;
			foreach ( $boxes as $key => $box ) {
				if ( !empty( $box['title'] ) || !empty( $box['content'] ) ) {
					$title = ( !empty( $box['title'] ) ) ? $box['title'] : __( '{empty}', 'magazine-news-byte-premium' );
					echo "<div class='hootkit-tabhead tabhead{$count} {$current}' data-tabcount='{$count}'>" . do_shortcode( wp_kses_post( $title ) ) . "</div>";
					$current = '';
					$count++;
				}
			}
			?>
		</div>

		<div class="hootkit-tabboxes">
			<?php
			$current = 'current-tabbox';
			$count = 1;
			foreach ( $boxes as $key => $box ) {
				if ( !empty( $box['title'] ) || !empty( $box['content'] ) ) {
					echo "<div class='hootkit-tabbox tabbox{$count} {$current}' data-tabcount='{$count}'>" . do_shortcode( wp_kses_post( wpautop( $box['content'] ) ) ) . "</div>";
					$current = '';
					$count++;
				}
			}
			?>
		</div>

</div>