<?php
// Return if no list to show
if ( empty( $items ) )
	return;

// Get icon
if ( !empty( $iconcolor ) ) {
	$styleclass = 'iconlist-userstyle';
	$inlinestyle = ' style="';
	$inlinestyle .= ( $iconcolor ) ? 'color:' . sanitize_hex_color( $iconcolor ) . ';' : '';
	$inlinestyle .= '" ';
} else $inlinestyle = $styleclass = '';
$icon = ( !empty( $icon ) ) ? '<i class="icon-list-i ' . hoot_sanitize_fa( $icon ) . ' ' . $styleclass . '" ' . $inlinestyle . '></i>' : '';

// Set vars
$subtitle = ( !empty( $subtitle ) ) ? $subtitle : '';
?>

<div class="icon-list-widget icon-list-icon<?php echo $iconsize; ?>">

	<?php
	/* Display Title */
	$titlemarkup = $titleclass = '';
	if ( !empty( $title ) ) {
		$titlemarkup .= $before_title . $title . $after_title;
		$titleclass .= ' hastitle';
	}
	$titlemarkup = ( !empty( $titlemarkup ) ) ? '<div class="widget-title-wrap' . $titleclass . '">' . $titlemarkup . '</div>' : '';
	$titlemarkup .= ( !empty( $subtitle ) ) ? '<div class="widget-subtitle hoot-subtitle">' . $subtitle . '</div>' : '';
	echo do_shortcode( wp_kses_post( apply_filters( 'hootkit_widget_title', $titlemarkup, 'icon-list', $title, $before_title, $after_title, $subtitle ) ) );
	?>

	<ul class="icon-list-ul">
		<?php
		foreach ( $items as $key => $item ) {
			if ( !empty( $item['text'] ) )
				echo '<li class="icon-list-li icon-list-li' . ($key+1) . '">' . $icon . do_shortcode( wp_kses_post( $item['text'] ) ) .'</li>';
		}
		?>
	</ul>

</div>