<?php
/**
 * This file contains functions and hooks for adding/modifying Hootkit plugin options
 *   Hootkit is a free plugin released under GPL license and hosted on wordpress.org.
 *   It is recommended to the user via wp-admin using TGMPA class
 *
 * This file is loaded at 'after_setup_theme' action @priority 10 ONLY IF hootkit plugin is active
 *
 * @package    Magazine News Byte
 * @subpackage HootKit
 */

/**
 * Modify Slider Image settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_slider_image_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['slides']['options']['maxlimit'] ) )
		unset( $settings['form_options']['slides']['options']['maxlimit'] );
	if ( isset( $settings['form_options']['slides']['options']['limitmsg'] ) )
		unset( $settings['form_options']['slides']['options']['limitmsg'] );
	$settings['form_options']['slides']['options']['dellimit'] = true;
	return $settings;
}
add_filter( 'hootkit_slider_image_widget_settings', 'magnb_premium_slider_image_widget_settings', 7 );

/**
 * Modify Slider PostImage settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_slider_postimage_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['count']['desc'] ) )
		unset( $settings['form_options']['count']['desc'] );
	if ( isset( $settings['form_options']['count']['options'] ) )
		unset( $settings['form_options']['count']['options'] );
	if ( isset( $settings['form_options']['count']['type'] ) ) {
		$settings['form_options']['count']['type'] = 'text';
		$settings['form_options']['count']['settings'] = array( 'size' => 3, );
		$settings['form_options']['count']['sanitize'] = 'absint';
	}
	return $settings;
}
add_filter( 'hootkit_slider_postimage_widget_settings', 'magnb_premium_slider_postimage_widget_settings', 7 );

/**
 * Modify Slider PostImage Query Args
 *
 * @since 1.0
 * @param array $query_args
 * @param array $instance
 * @return string
 */
function magnb_premium_slider_postimage_query( $query_args, $instance ) {
	$count = ( isset( $instance['count'] ) ) ? $instance['count'] : 4;
	$count = intval( $count );
	$query_args['posts_per_page'] = ( empty( $count ) ) ? 4 : $count;
	return $query_args;
}
add_filter( 'hootkit_slider_postimage_query', 'magnb_premium_slider_postimage_query', 7, 2 );

/**
 * Modify Slider Carousel settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_slider_carousel_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['slides']['options']['maxlimit'] ) )
		unset( $settings['form_options']['slides']['options']['maxlimit'] );
	if ( isset( $settings['form_options']['slides']['options']['limitmsg'] ) )
		unset( $settings['form_options']['slides']['options']['limitmsg'] );
	$settings['form_options']['slides']['options']['dellimit'] = true;
	return $settings;
}
add_filter( 'hootkit_slider_carousel_widget_settings', 'magnb_premium_slider_carousel_widget_settings', 7 );

/**
 * Modify Slider PostCarousel settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_slider_postcarousel_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['count']['desc'] ) )
		$settings['form_options']['count']['desc'] = __( 'Total number of posts in the carousel. Default: 10',  'magazine-news-byte-premium' );
	if ( isset( $settings['form_options']['count']['options'] ) )
		unset( $settings['form_options']['count']['options'] );
	if ( isset( $settings['form_options']['count']['type'] ) ) {
		$settings['form_options']['count']['type'] = 'text';
		$settings['form_options']['count']['std'] = '10';
		$settings['form_options']['count']['settings'] = array( 'size' => 3, );
		$settings['form_options']['count']['sanitize'] = 'absint';
	}
	return $settings;
}
add_filter( 'hootkit_slider_postcarousel_widget_settings', 'magnb_premium_slider_postcarousel_widget_settings', 7 );

/**
 * Modify Slider PostCarousel Query Args
 *
 * @since 1.0
 * @param array $query_args
 * @param array $instance
 * @return string
 */
function magnb_premium_slider_postcarousel_query( $query_args, $instance ) {
	$count = ( isset( $instance['count'] ) ) ? $instance['count'] : 10;
	$count = intval( $count );
	$query_args['posts_per_page'] = ( empty( $count ) ) ? 10 : $count;
	return $query_args;
}
add_filter( 'hootkit_slider_postcarousel_query', 'magnb_premium_slider_postcarousel_query', 7, 2 );

/**
 * Modify Slider PostListCarousel settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_slider_postlistcarousel_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['count']['desc'] ) )
		$settings['form_options']['count']['desc'] = __( 'Total number of posts in the carousel. Default: 10',  'magazine-news-byte-premium' );
	if ( isset( $settings['form_options']['count']['options'] ) )
		unset( $settings['form_options']['count']['options'] );
	if ( isset( $settings['form_options']['count']['type'] ) ) {
		$settings['form_options']['count']['type'] = 'text';
		$settings['form_options']['count']['std'] = '10';
		$settings['form_options']['count']['settings'] = array( 'size' => 3, );
		$settings['form_options']['count']['sanitize'] = 'absint';
	}
	return $settings;
}
add_filter( 'hootkit_slider_postlistcarousel_widget_settings', 'magnb_premium_slider_postlistcarousel_widget_settings', 7 );

/**
 * Modify Slider PostListCarousel Query Args
 *
 * @since 1.0
 * @param array $query_args
 * @param array $instance
 * @return string
 */
function magnb_premium_slider_postlistcarousel_query( $query_args, $instance ) {
	$count = ( isset( $instance['count'] ) ) ? $instance['count'] : 10;
	$count = intval( $count );
	$query_args['posts_per_page'] = ( empty( $count ) ) ? 10 : $count;
	return $query_args;
}
add_filter( 'hootkit_slider_postlistcarousel_query', 'magnb_premium_slider_postlistcarousel_query', 7, 2 );

/**
 * Modify social icons settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_social_icons_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['icons']['options']['maxlimit'] ) )
		unset( $settings['form_options']['icons']['options']['maxlimit'] );
	if ( isset( $settings['form_options']['icons']['options']['limitmsg'] ) )
		unset( $settings['form_options']['icons']['options']['limitmsg'] );
	$settings['form_options']['icons']['options']['dellimit'] = true;
	return $settings;
}
add_filter( 'hootkit_social_icons_widget_settings', 'magnb_premium_social_icons_widget_settings', 7 );

/**
 * Modify Contact Info settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_contact_info_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['profiles']['options']['maxlimit'] ) )
		unset( $settings['form_options']['profiles']['options']['maxlimit'] );
	if ( isset( $settings['form_options']['profiles']['options']['limitmsg'] ) )
		unset( $settings['form_options']['profiles']['options']['limitmsg'] );
	$settings['form_options']['profiles']['options']['dellimit'] = true;
	return $settings;
}
add_filter( 'hootkit_contact_info_widget_settings', 'magnb_premium_contact_info_widget_settings', 7 );

/**
 * Modify vcards settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_vcards_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['vcards']['options']['maxlimit'] ) )
		unset( $settings['form_options']['vcards']['options']['maxlimit'] );
	if ( isset( $settings['form_options']['vcards']['options']['limitmsg'] ) )
		unset( $settings['form_options']['vcards']['options']['limitmsg'] );
	$settings['form_options']['vcards']['options']['dellimit'] = true;
	return $settings;
}
add_filter( 'hootkit_vcards_widget_settings', 'magnb_premium_vcards_widget_settings', 7 );

/**
 * Modify Number Blocks settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_number_blocks_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['boxes']['options']['maxlimit'] ) )
		unset( $settings['form_options']['boxes']['options']['maxlimit'] );
	if ( isset( $settings['form_options']['boxes']['options']['limitmsg'] ) )
		unset( $settings['form_options']['boxes']['options']['limitmsg'] );
	$settings['form_options']['boxes']['options']['dellimit'] = true;
	return $settings;
}
add_filter( 'hootkit_number_blocks_widget_settings', 'magnb_premium_number_blocks_widget_settings', 7 );

/**
 * Modify Button settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_buttons_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['buttons']['options']['maxlimit'] ) )
		unset( $settings['form_options']['buttons']['options']['maxlimit'] );
	if ( isset( $settings['form_options']['buttons']['options']['limitmsg'] ) )
		unset( $settings['form_options']['buttons']['options']['limitmsg'] );
	$settings['form_options']['buttons']['options']['dellimit'] = true;
	if ( isset( $settings['form_options']['buttons']['fields']['preset']['options'] ) )
		$settings['form_options']['buttons']['fields']['preset']['options'] = array_merge(
			array( 'accent' => __( 'Theme Accent Color',  'magazine-news-byte-premium' ), ),
			$settings['form_options']['buttons']['fields']['preset']['options']
		);
	return $settings;
}
add_filter( 'hootkit_buttons_widget_settings', 'magnb_premium_buttons_widget_settings', 7 );

/**
 * Modify Icon List settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_icon_list_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['items']['options']['maxlimit'] ) )
		unset( $settings['form_options']['items']['options']['maxlimit'] );
	if ( isset( $settings['form_options']['items']['options']['limitmsg'] ) )
		unset( $settings['form_options']['items']['options']['limitmsg'] );
	$settings['form_options']['items']['options']['dellimit'] = true;
	return $settings;
}
add_filter( 'hootkit_icon_list_widget_settings', 'magnb_premium_icon_list_widget_settings', 7 );

/**
 * Modify Notice settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_notice_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['preset']['options'] ) )
		$settings['form_options']['preset']['options'] = array_merge(
			array( 'accent' => __( 'Theme Accent Color',  'magazine-news-byte-premium' ), ),
			$settings['form_options']['preset']['options']
		);
	return $settings;
}
add_filter( 'hootkit_notice_widget_settings', 'magnb_premium_notice_widget_settings', 7 );

/**
 * Modify Toggle settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_toggle_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['boxes']['options']['maxlimit'] ) )
		unset( $settings['form_options']['boxes']['options']['maxlimit'] );
	if ( isset( $settings['form_options']['boxes']['options']['limitmsg'] ) )
		unset( $settings['form_options']['boxes']['options']['limitmsg'] );
	$settings['form_options']['boxes']['options']['dellimit'] = true;
	return $settings;
}
add_filter( 'hootkit_toggle_widget_settings', 'magnb_premium_toggle_widget_settings', 7 );

/**
 * Modify Tabs settings
 *
 * @since 1.0
 * @param array $settings
 * @return string
 */
function magnb_premium_tabs_widget_settings( $settings ) {
	if ( isset( $settings['form_options']['boxes']['options']['maxlimit'] ) )
		unset( $settings['form_options']['boxes']['options']['maxlimit'] );
	if ( isset( $settings['form_options']['boxes']['options']['limitmsg'] ) )
		unset( $settings['form_options']['boxes']['options']['limitmsg'] );
	$settings['form_options']['boxes']['options']['dellimit'] = true;
	return $settings;
}
add_filter( 'hootkit_tabs_widget_settings', 'magnb_premium_tabs_widget_settings', 7 );