<?php
/**
 * Auto Theme Updater
 * This file is loaded at 'init' hook
 *
 * @package    Magazine News Byte
 * @subpackage Library Premium
 */

/**
 * Theme Updater class. This wraps everything up nicely.
 *
 * @since 3.0.0
 */
final class Hoot_Manager_Updater {

	protected $args = array();
	protected $childargs = array();

	public function __construct( $args = array(), $childargs = array() ) {

		$this->args = $args;
		$this->childargs = $childargs;

		/* Keys to store transients in db */
		$this->args['response_key'] = str_replace( '_', '-', hoot_data()->basetemplate_slug ) . '-update-response';
		if ( is_child_theme() )
			$this->childargs['response_key'] = str_replace( '_', '-', hoot_data()->basechildtheme_slug ) . '-update-response';
		// var_dump($this->args); var_dump($this->childargs); exit; // @TS

		/* Update Stuff */
		add_filter( 'pre_set_site_transient_update_themes', array( &$this, 'theme_update_transient' ) );
		add_filter( 'delete_site_transient_update_themes',  array( &$this, 'delete_theme_update_transient' ) );
		add_action( 'load-update-core.php',                 array( &$this, 'delete_theme_update_transient' ) );
		add_action( 'load-themes.php',                      array( &$this, 'delete_theme_update_transient' ) );
		add_action( 'load-themes.php',                      array( &$this, 'load_themes_screen' ) );

	}

	function load_themes_screen() {
		add_thickbox();
		add_action( 'admin_notices', array( &$this, 'update_nag' ) );
	}

	function update_nag() {
		$nag = $changelog = '';

		$api_response = get_transient( $this->args['response_key'] );
		if ( false !== $api_response ) {
			// var_dump($this->args['version'], $api_response->new_version); // @TS
			if ( version_compare( $this->args['version'], $api_response->new_version, '<' ) ) {
				$nag .= sprintf(
					__('New version <strong>%2$s</strong> available for <strong>%1$s</strong>. <a href="%3$s" class="thickbox">Check out what\'s new</a>', 'magazine-news-byte-premium' ),
					hoot_data()->template_name, // hoot_data()->basetemplate_name,
					$api_response->new_version,
					'#TB_inline?width=640&amp;inlineId=' . $this->args['theme_slug'] . '_changelog'
					// $api_response->url . '&TB_iframe=true'
				);
				$changelog .= '<div id="' . $this->args['theme_slug'] . '_changelog" style="display:none;">' . $api_response->sections['changelog'] . '</div>';
			}
		}

		if ( is_child_theme() ) :
		$api_response = get_transient( $this->childargs['response_key'] );
		if ( false !== $api_response ) {
			// var_dump($this->childargs['child_version'], $api_response->new_version); // @TS
			if ( version_compare( $this->childargs['child_version'], $api_response->new_version, '<' ) ) {
				if ( !empty( $nag ) ) $nag .= '<br />';
				$nag .= sprintf(
					__('New version <strong>%2$s</strong> available for <strong>%1$s</strong>. <a href="%3$s" class="thickbox">Check out what\'s new</a>', 'magazine-news-byte-premium' ),
					hoot_data()->childtheme_name,
					$api_response->new_version,
					'#TB_inline?width=640&amp;inlineId=' . $this->childargs['childtheme_slug'] . '_changelog'
					// $api_response->url . '&TB_iframe=true'
				);
				$changelog .= '<div id="' . $this->childargs['childtheme_slug'] . '_changelog" style="display:none;">' . $api_response->sections['changelog'] . '</div>';
			}
		}
		endif;

		if ( !empty( $nag ) )
			echo '<div id="update-nag">' . $nag . '</div>' . $changelog;

		return;
	}

	function theme_update_transient( $value ) {
		// if( isset($this->args['response_key'])) delete_transient( $this->args['response_key'] ); if( isset($this->childargs['response_key'])) delete_transient( $this->childargs['response_key'] ); // @TS - Activate Troubleshooting
		$update_data = $this->check_for_update();
		if ( $update_data ) {
			if ( ! is_object( $value ) ) { $value = new stdClass; }
			// Make sure the theme property is set. See issue 1463 on Github in the Software Licensing Repo.
			$update_data['theme'] = $this->args['premium_slug'];
			if ( version_compare( $this->args['version'], $update_data['new_version'], '<' ) ) {
				$value->response[ $this->args['premium_slug'] ] = $update_data;
			} else {
				$value->no_update[ $this->args['premium_slug'] ] = $update_data;
			}
		}
		if ( is_child_theme() ) {
			$update_childdata = $this->check_for_childupdate();
			if ( $update_childdata ) {
				if ( ! is_object( $value ) ) { $value = new stdClass; }
				// Make sure the theme property is set. See issue 1463 on Github in the Software Licensing Repo.
				$update_childdata['theme'] = $this->childargs['childpremium_slug'];
				if ( version_compare( $this->childargs['child_version'], $update_childdata['new_version'], '<' ) ) {
					$value->response[ $this->childargs['childpremium_slug'] ] = $update_childdata;
				} else {
					$value->no_update[ $this->childargs['childpremium_slug'] ] = $update_childdata;
				}
			}
		}
		// var_dump($update_data, $update_childdata, $value); exit; // @TS
		return $value;
	}

	function delete_theme_update_transient() {
		delete_transient( $this->args['response_key'] );
		if ( is_child_theme() )
			delete_transient( $this->childargs['response_key'] );
	}

	function check_for_update() {
		$update_data = get_transient( $this->args['response_key'] );

		if ( false === $update_data ) {
			$failed = false;

			$api_params = array(
				'edd_action' 	=> 'get_version',
				'license' 		=> $this->args['license'],
				'name' 			=> $this->args['item_name'],
				'slug' 			=> $this->args['theme_slug'],
				'version'		=> $this->args['version'], // Not actually used in SL
				'author'		=> $this->args['author'],  // Not actually used in SL
				'beta'			=> $this->args['beta']
			);

			$response = wp_remote_post( $this->args['remote_api_url'], array( 'timeout' => 15, 'body' => $api_params ) );
			// var_dump($response); exit; // @TS - Check for PHP errors in source code

			// Make sure the response was successful
			if ( is_wp_error( $response ) || 200 != wp_remote_retrieve_response_code( $response ) ) {
				$failed = true;
			}

			$update_data = json_decode( wp_remote_retrieve_body( $response ) );

			if ( ! is_object( $update_data ) ) {
				$failed = true;
			}

			// If the response failed, try again in 30 minutes
			if ( $failed ) {
				$data = new stdClass;
				$data->new_version = $this->args['version'];
				set_transient( $this->args['response_key'], $data, strtotime( '+30 minutes', time() ) );
				return false;
			}

			// If the status is 'ok', return the update arguments
			if ( ! $failed ) {
				$update_data->sections = maybe_unserialize( $update_data->sections );
				set_transient( $this->args['response_key'], $update_data, strtotime( '+12 hours', time() ) );
			}
		}

		if ( version_compare( $this->args['version'], $update_data->new_version, '>=' ) ) {
			return false;
		}

		return (array) $update_data;
	}

	function check_for_childupdate() {

		$update_data = get_transient( $this->childargs['response_key'] );

		if ( false === $update_data ) {
			$failed = false;

			$api_params = array(
				'edd_action' 	=> 'get_version',
				'license' 		=> $this->childargs['license'],
				'name' 			=> $this->childargs['item_name'],     // most likely dont use child_name -> used in SL?
				'slug' 			=> $this->childargs['theme_slug'],    // most likely dont use childtheme_slug -> used in SL?
				'version'		=> $this->childargs['child_version'], // Not actually used in SL
				'author'		=> $this->childargs['author'],        // Not actually used in SL
				'beta'			=> $this->childargs['beta'],
			);
			if ( !empty( $this->childargs['childpremium_name'] ) )
				$api_params['childpremium_name'] =  $this->childargs['childpremium_name'];

			$response = wp_remote_post( $this->childargs['remote_api_url'], array( 'timeout' => 15, 'body' => $api_params ) );
			// var_dump($response); exit; // @TS - Check for PHP errors in source code

			// Make sure the response was successful
			if ( is_wp_error( $response ) || 200 != wp_remote_retrieve_response_code( $response ) ) {
				$failed = true;
			}

			$update_data = json_decode( wp_remote_retrieve_body( $response ) );

			if ( ! is_object( $update_data ) ) {
				$failed = true;
			}

			// If the response failed, try again in 30 minutes
			if ( $failed ) {
				$data = new stdClass;
				$data->new_version = $this->childargs['child_version'];
				set_transient( $this->childargs['response_key'], $data, strtotime( '+30 minutes', time() ) );
				return false;
			}

			// If the status is 'ok', return the update arguments
			if ( ! $failed ) {
				$update_data->sections = maybe_unserialize( $update_data->sections );
				set_transient( $this->childargs['response_key'], $update_data, strtotime( '+12 hours', time() ) );
			}
		}

		if ( version_compare( $this->childargs['child_version'], $update_data->new_version, '>=' ) ) {
			return false;
		}

		return (array) $update_data;
	}

}