jQuery(document).ready(function($) {
	"use strict";

	if( 'undefined' == typeof hootData )
		window.hootData = {};

	/*** Generic hootScroller ***/

	$.fn.hootScroller = function (options) {

		var scrollSpeed = 500,
			scrollPadding = 50;
		if( 'undefined' != typeof hootData && 'undefined' != typeof hootData.customScrollerSpeed )
			scrollSpeed = hootData.customScrollerSpeed;
		if( 'undefined' != typeof hootData && 'undefined' != typeof hootData.customScrollerPadding )
			scrollPadding = hootData.customScrollerPadding;

		// Options
		var settings = $.extend({
			urlLoad: false,                 // value: boolean
			speed: scrollSpeed,         // value: integer
			padding: scrollPadding,     // value: integer
		}, options);

		// Scroll to hash
		if (typeof scrollToHash == 'undefined') {
			var scrollToHash = function( target ) {
				target = target.replace("#scrollpoint-", "#"); // replace first occurence
				if ( target.length > 1 ){
					var $target = $( target );
					if ( $target.length ) {
						var destin = $target.offset().top - settings.padding;
						$("html:not(:animated),body:not(:animated)").animate({ scrollTop: destin}, settings.speed );
						return true;
					}
				}
				return false;
			};
		};

		return this.each(function () {
			if( 'undefined' == typeof hootData.scroller || 'enable' == hootData.scroller ) {

				if ( settings.urlLoad ) {
					if( 'undefined' == typeof hootData.scrollerPageLoad || 'enable' == hootData.scrollerPageLoad ) {
						var target = window.location.hash;
						if ( target ) {
							target = target.split("&");
							target = target[0].split("?");
							target = target[0].split("=");
							scrollToHash(target[0]);
						}
					}
				} else {

					var $self = $(this),
						executed = '',
						parseHref = $self.attr('href');

					if(typeof parseHref != 'undefined')
						parseHref = parseHref.replace(/#([A-Za-z0-9\-\_]+)/g,'#scrollpoint-$1');
					else
						return; // Bugfix: We can break the $.each() loop at a particular iteration by making the callback function return false. Returning non-false is the same as a continue statement in a for loop; it will skip immediately to the next iteration.

					// Add namespace so when new page is loaded, the hashtag has unique namespace (this ways the script overtakes browser behavior to scroll to hashtag on pageload)
					if( 'undefined' == typeof hootData.scrollerPageLoad || 'enable' == hootData.scrollerPageLoad )
						$self.attr('href', parseHref);

					$self.on('click', function(e) {
						// Only if href points to current url
						// $self.context.pathname is empty in IE11, so we need to scrape off this test
						// if ( $self.context.pathname == window.location.pathname ) {
							executed = '';
							if ( $self.prop('hash') )
								executed = scrollToHash( $self.prop('hash') );
							if ( !executed && $self.attr('data-scrollto') )
								executed = scrollToHash( $self.attr('data-scrollto') );
							if ( executed )
								e.preventDefault();
						// }
					});

				}

			}
		});

	};

	/*** Top Button ***/

	if( 'undefined' == typeof hootData.topButton || 'enable' == hootData.topButton ) {
		$('.fixed-goto-top').hootScroller({padding:0});
		var $top_btn = $('.waypoints-goto-top');
		if ( $top_btn.length ) {
			if (typeof Waypoint === "function") {
				var waypoints = $('#page-wrapper').waypoint(function(direction) {
					if(direction=='down')
						$top_btn.addClass('topshow');
					if(direction=='up')
						$top_btn.removeClass('topshow');
					},{offset: '-80%'});
			} else {
				$top_btn.addClass('topshow');
			}
		}
	}

	/*** Scrollpoints ***/

	// Watch all links within .scrollpoints container and links with .scrollpoint
	// => used for implementing Menu Scroll
	if( 'undefined' == typeof hootData.scrollpointsContainer || 'enable' == hootData.scrollpointsContainer ) {
		$('.scrollpointscontainer a, a.scrollpoint').hootScroller();
	}

	/*** Scroll on URL Load ***/

	// Scroll on url load has a few inherent issues. Complying with standard url hash structure, we
	// cant override browser behavior. Adopting additional methods (prepend hash tag with unique id,
	// or using query args instead of hash) leads to non standard url (what if when user changes
	// themes).
	// Hence possible solution for now: Pepend hash tag with unique id using scroller js only..
	if( 'undefined' == typeof hootData.urlScroller || 'enable' == hootData.urlScroller ) {
		$('#page-wrapper').hootScroller({urlLoad:true, speed:1500});
	}

	/*** Sticky Header ***/

	if( 'undefined' == typeof hootData.stickyHeader || 'enable' == hootData.stickyHeader ) {
		if (typeof Waypoint === "function" && $('.hoot-sticky-header #header').length) {
			var offset = -300; // offset = -10 // fixes bug: header gets stuck when no topbar i.e. header is at top 0 at page load
			if( 'undefined' != typeof hootData && 'undefined' != typeof hootData.stickyHeaderOffset )
				offset = hootData.stickyHeaderOffset;
			if ( typeof Waypoint.Sticky === 'undefined' ) {

				  // var Waypoint = window.Waypoint

				  /* http://imakewebthings.com/waypoints/shortcuts/sticky-elements */
				  function Sticky(options) {
				    this.options = $.extend({}, Waypoint.defaults, Sticky.defaults, options)
				    this.element = this.options.element
				    this.$element = $(this.element)
				    this.createWrapper()
				    this.createWaypoint()
				  }

				  /* Private */
				  Sticky.prototype.createWaypoint = function() {
				    var originalHandler = this.options.handler

				    this.waypoint = new Waypoint($.extend({}, this.options, {
				      element: this.wrapper,
				      handler: $.proxy(function(direction) {
				        var shouldBeStuck = this.options.direction.indexOf(direction) > -1
				        var wrapperHeight = shouldBeStuck ? this.$element.outerHeight(true) : ''

				        this.$wrapper.height(wrapperHeight)
				        this.$element.toggleClass(this.options.stuckClass, shouldBeStuck)

				        if (originalHandler) {
				          originalHandler.call(this, direction)
				        }
				      }, this)
				    }))
				  }

				  /* Private */
				  Sticky.prototype.createWrapper = function() {
				    if (this.options.wrapper) {
				      this.$element.wrap(this.options.wrapper)
				    }
				    this.$wrapper = this.$element.parent()
				    this.wrapper = this.$wrapper[0]
				  }

				  /* Public */
				  Sticky.prototype.destroy = function() {
				    if (this.$element.parent()[0] === this.wrapper) {
				      this.waypoint.destroy()
				      this.$element.removeClass(this.options.stuckClass)
				      if (this.options.wrapper) {
				        this.$element.unwrap()
				      }
				    }
				  }

				  Sticky.defaults = {
				    wrapper: '<div class="sticky-wrapper" />',
				    stuckClass: 'stuck',
				    direction: 'down right'
				  }

				  Waypoint.Sticky = Sticky;

			}


			if ( typeof Waypoint.Sticky === 'function' ) {
				var stickyHeader = new Waypoint.Sticky({
					element: $('.hoot-sticky-header #header')[0],
					offset: offset
				});
			} else { console.log( 'Waypoint exist. Sticky does not.'); }
		}
	}

});