<?php
/**
 * Loads up all the necessary libraries and functions.
 * This file is loaded after core theme's library/init and include/hoot-theme have loaded
 *
 * @package    Magazine News Byte
 * @subpackage Library Premium
 */

/* Define parent theme, and child theme constants. */
add_action( 'after_setup_theme', 'hoot_lib_premium_constants', 3 );

/* Load the core functions/classes */
add_action( 'after_setup_theme', 'hoot_lib_premium_core', 4 );

/**
 * Defines the constant paths for use throughout the theme.
 *
 * @since 3.0.0
 * @access public
 * @return void
 */
if ( !function_exists( 'hoot_lib_premium_constants' ) ) :
function hoot_lib_premium_constants() {

	// Set Theme Location Constants
	hoot_set_data( 'template_premium_dir', trailingslashit( hoot_data()->template_dir . 'premium' ) );
	hoot_set_data( 'template_premium_uri', trailingslashit( hoot_data()->template_uri . 'premium' ) );
	hoot_set_data( 'premium_libdir',       trailingslashit( hoot_data()->template_premium_dir . 'library' ) );
	hoot_set_data( 'premium_liburi',       trailingslashit( hoot_data()->template_premium_uri . 'library' ) );
	hoot_set_data( 'premium_incdir',       trailingslashit( hoot_data()->template_premium_dir . 'include' ) );
	hoot_set_data( 'premium_incuri',       trailingslashit( hoot_data()->template_premium_uri . 'include' ) );

	// Set the template name
	hoot_set_data( 'basetemplate_name',    preg_replace( '/ ?premium/i', '', hoot_data()->template_name ) );

	// Sets the theme slug
	$template_slug = strtolower( preg_replace( '/[^a-zA-Z0-9]+/', '_', trim( hoot_data()->template_name ) ) );
	hoot_set_data( 'basetemplate_slug',    preg_replace( '/_?premium/', '', $template_slug ) ); // instead of '/_?premium$/'

	// Child Theme
	if ( is_child_theme() ) {
		hoot_set_data( 'basechildtheme_name',    preg_replace( '/ ?premium/i', '', hoot_data()->childtheme_name ) );
		$childtheme_slug = strtolower( preg_replace( '/[^a-zA-Z0-9]+/', '_', trim( hoot_data()->childtheme_name ) ) );
		hoot_set_data( 'basechildtheme_slug',    preg_replace( '/_?premium/', '', $childtheme_slug ) ); // instead of '/_?premium$/'
	}

}
endif;

/**
 * Loads the core classes & functions. These files are needed before loading anything else in the 
 * theme because they have required functions for use. Many of the files run filters that 
 * may be removed using child theme or plugins.
 *
 * @since 3.0.0
 * @access public
 * @return void
 */
if ( !function_exists( 'hoot_lib_premium_core' ) ) :
function hoot_lib_premium_core() {

	/* Hook into core theme's library functions */
	require_once( hoot_data()->premium_libdir . 'hooks.php' );
	/* Load the data set functions => also needed for sanitization. */
	require_once( hoot_data()->premium_libdir . 'enum.php' );
	/* Load the Scroller extension */
	require_once( hoot_data()->premium_libdir . 'scroller.php' );
	/* Load the Megamenu extension */
	require_once( hoot_data()->premium_libdir . 'megamenu/megamenu.php' );
	/* Load the Customize extension */
	require_once( hoot_data()->premium_libdir . 'customize/customize.php' );
	/* Load Meta extension */
	require_once( hoot_data()->premium_libdir . 'metaoptions/metaoptions.php' );
	/* Load the theme manager extension. */
	// needed outside admin (cron jobs) to enable theme auto update. instead check within Hoot_MAnager class
	// if ( is_admin() && current_user_can( 'edit_theme_options' ) )
	require_once( hoot_data()->premium_libdir . 'manager/manager.php' );

}
endif;

/* Premium Setup complete */
do_action( 'hoot_library_premium_loaded' );