<?php
/**
 * Data Sets
 * These sets can be easily used to create option lists and
 * subsequently by sanitization functions to check for allowed values
 *
 * @package    Magazine News Byte
 * @subpackage Library Premium
 */


/* == fonts == */


/**
 * Generates the font (google font) list
 * Font list should always have the form: {css style} => {font name}
 * where {css-style} is the font family as used in css rules, and {font name} is the font name exactly
 * as used in Google URL for enqueuing font css file.
 *
 * @since 3.0.0
 * @access public
 * @return array
 */
function hoot_googlefonts_list() {

	// @todo only 'serif' done. Remaining 'sans-serif' need to be adjusted (cursive, mono)
	return apply_filters( 'hoot_googlefonts_list', array(
		'"ABeeZee", sans-serif' => 'ABeeZee',
		'"Abel", sans-serif' => 'Abel',
		'"Abril Fatface", sans-serif' => 'Abril Fatface',
		'"Aclonica", sans-serif' => 'Aclonica',
		'"Acme", sans-serif' => 'Acme',
		'"Actor", sans-serif' => 'Actor',
		'"Adamina", serif' => 'Adamina',
		'"Advent Pro", sans-serif' => 'Advent Pro',
		'"Aguafina Script", sans-serif' => 'Aguafina Script',
		'"Akronim", sans-serif' => 'Akronim',
		'"Aladin", sans-serif' => 'Aladin',
		'"Aldrich", sans-serif' => 'Aldrich',
		'"Alegreya", serif' => 'Alegreya',
		'"Alegreya SC", serif' => 'Alegreya SC',
		'"Alex Brush", sans-serif' => 'Alex Brush',
		'"Alfa Slab One", sans-serif' => 'Alfa Slab One',
		'"Alice", serif' => 'Alice',
		'"Alike", serif' => 'Alike',
		'"Alike Angular", serif' => 'Alike Angular',
		'"Allan", sans-serif' => 'Allan',
		'"Allerta", sans-serif' => 'Allerta',
		'"Allerta Stencil", sans-serif' => 'Allerta Stencil',
		'"Allura", sans-serif' => 'Allura',
		'"Almendra", serif' => 'Almendra',
		'"Almendra Display", sans-serif' => 'Almendra Display',
		'"Almendra SC", serif' => 'Almendra SC',
		'"Amarante", sans-serif' => 'Amarante',
		'"Amaranth", sans-serif' => 'Amaranth',
		'"Amatic SC", sans-serif' => 'Amatic SC',
		'"Amethysta", serif' => 'Amethysta',
		'"Anaheim", sans-serif' => 'Anaheim',
		'"Andada", serif' => 'Andada',
		'"Andika", sans-serif' => 'Andika',
		'"Angkor", sans-serif' => 'Angkor',
		'"Annie Use Your Telescope", sans-serif' => 'Annie Use Your Telescope',
		'"Anonymous Pro", sans-serif' => 'Anonymous Pro',
		'"Antic", sans-serif' => 'Antic',
		'"Antic Didone", serif' => 'Antic Didone',
		'"Antic Slab", serif' => 'Antic Slab',
		'"Anton", sans-serif' => 'Anton',
		'"Arapey", serif' => 'Arapey',
		'"Arbutus", sans-serif' => 'Arbutus',
		'"Arbutus Slab", serif' => 'Arbutus Slab',
		'"Architects Daughter", sans-serif' => 'Architects Daughter',
		'"Archivo Black", sans-serif' => 'Archivo Black',
		'"Archivo Narrow", sans-serif' => 'Archivo Narrow',
		'"Arimo", sans-serif' => 'Arimo',
		'"Arizonia", sans-serif' => 'Arizonia',
		'"Armata", sans-serif' => 'Armata',
		'"Artifika", serif' => 'Artifika',
		'"Arvo", serif' => 'Arvo',
		'"Asap", sans-serif' => 'Asap',
		'"Asset", sans-serif' => 'Asset',
		'"Astloch", sans-serif' => 'Astloch',
		'"Asul", sans-serif' => 'Asul',
		'"Atomic Age", sans-serif' => 'Atomic Age',
		'"Aubrey", sans-serif' => 'Aubrey',
		'"Audiowide", sans-serif' => 'Audiowide',
		'"Autour One", sans-serif' => 'Autour One',
		'"Average", serif' => 'Average',
		'"Average Sans", sans-serif' => 'Average Sans',
		'"Averia Gruesa Libre", sans-serif' => 'Averia Gruesa Libre',
		'"Averia Libre", sans-serif' => 'Averia Libre',
		'"Averia Sans Libre", sans-serif' => 'Averia Sans Libre',
		'"Averia Serif Libre", sans-serif' => 'Averia Serif Libre',
		'"Bad Script", sans-serif' => 'Bad Script',
		'"Balthazar", serif' => 'Balthazar',
		'"Bangers", sans-serif' => 'Bangers',
		'"Basic", sans-serif' => 'Basic',
		'"Battambang", sans-serif' => 'Battambang',
		'"Baumans", sans-serif' => 'Baumans',
		'"Bayon", sans-serif' => 'Bayon',
		'"Belgrano", serif' => 'Belgrano',
		'"Belleza", sans-serif' => 'Belleza',
		'"BenchNine", sans-serif' => 'BenchNine',
		'"Bentham", serif' => 'Bentham',
		'"Berkshire Swash", sans-serif' => 'Berkshire Swash',
		'"Bevan", sans-serif' => 'Bevan',
		'"Bigelow Rules", sans-serif' => 'Bigelow Rules',
		'"Bigshot One", sans-serif' => 'Bigshot One',
		'"Bilbo", sans-serif' => 'Bilbo',
		'"Bilbo Swash Caps", sans-serif' => 'Bilbo Swash Caps',
		'"Bitter", serif' => 'Bitter',
		'"Black Ops One", sans-serif' => 'Black Ops One',
		'"Bokor", sans-serif' => 'Bokor',
		'"Bonbon", sans-serif' => 'Bonbon',
		'"Boogaloo", sans-serif' => 'Boogaloo',
		'"Bowlby One", sans-serif' => 'Bowlby One',
		'"Bowlby One SC", sans-serif' => 'Bowlby One SC',
		'"Brawler", serif' => 'Brawler',
		'"Bree Serif", serif' => 'Bree Serif',
		'"Bubblegum Sans", sans-serif' => 'Bubblegum Sans',
		'"Bubbler One", sans-serif' => 'Bubbler One',
		'"Buda", sans-serif' => 'Buda',
		'"Buenard", serif' => 'Buenard',
		'"Butcherman", sans-serif' => 'Butcherman',
		'"Butterfly Kids", sans-serif' => 'Butterfly Kids',
		'"Cabin", sans-serif' => 'Cabin',
		'"Cabin Condensed", sans-serif' => 'Cabin Condensed',
		'"Cabin Sketch", sans-serif' => 'Cabin Sketch',
		'"Caesar Dressing", sans-serif' => 'Caesar Dressing',
		'"Cagliostro", sans-serif' => 'Cagliostro',
		'"Calligraffitti", sans-serif' => 'Calligraffitti',
		'"Cambo", serif' => 'Cambo',
		'"Candal", sans-serif' => 'Candal',
		'"Cantarell", sans-serif' => 'Cantarell',
		'"Cantata One", serif' => 'Cantata One',
		'"Cantora One", sans-serif' => 'Cantora One',
		'"Capriola", sans-serif' => 'Capriola',
		'"Cardo", serif' => 'Cardo',
		'"Carme", sans-serif' => 'Carme',
		'"Carrois Gothic", sans-serif' => 'Carrois Gothic',
		'"Carrois Gothic SC", sans-serif' => 'Carrois Gothic SC',
		'"Carter One", sans-serif' => 'Carter One',
		'"Caudex", serif' => 'Caudex',
		'"Cedarville Cursive", sans-serif' => 'Cedarville Cursive',
		'"Ceviche One", sans-serif' => 'Ceviche One',
		'"Changa One", sans-serif' => 'Changa One',
		'"Chango", sans-serif' => 'Chango',
		'"Chau Philomene One", sans-serif' => 'Chau Philomene One',
		'"Chela One", sans-serif' => 'Chela One',
		'"Chelsea Market", sans-serif' => 'Chelsea Market',
		'"Chenla", sans-serif' => 'Chenla',
		'"Cherry Cream Soda", sans-serif' => 'Cherry Cream Soda',
		'"Cherry Swash", sans-serif' => 'Cherry Swash',
		'"Chewy", sans-serif' => 'Chewy',
		'"Chicle", sans-serif' => 'Chicle',
		'"Chivo", sans-serif' => 'Chivo',
		'"Cinzel", serif' => 'Cinzel',
		'"Cinzel Decorative", sans-serif' => 'Cinzel Decorative',
		'"Clicker Script", sans-serif' => 'Clicker Script',
		'"Coda", sans-serif' => 'Coda',
		'"Coda Caption", sans-serif' => 'Coda Caption',
		'"Codystar", sans-serif' => 'Codystar',
		'"Combo", sans-serif' => 'Combo',
		'"Comfortaa", sans-serif' => 'Comfortaa',
		'"Coming Soon", sans-serif' => 'Coming Soon',
		'"Concert One", sans-serif' => 'Concert One',
		'"Condiment", sans-serif' => 'Condiment',
		'"Content", sans-serif' => 'Content',
		'"Contrail One", sans-serif' => 'Contrail One',
		'"Convergence", sans-serif' => 'Convergence',
		'"Cookie", sans-serif' => 'Cookie',
		'"Copse", serif' => 'Copse',
		'"Corben", sans-serif' => 'Corben',
		'"Courgette", sans-serif' => 'Courgette',
		'"Cousine", sans-serif' => 'Cousine',
		'"Coustard", serif' => 'Coustard',
		'"Covered By Your Grace", sans-serif' => 'Covered By Your Grace',
		'"Crafty Girls", sans-serif' => 'Crafty Girls',
		'"Creepster", sans-serif' => 'Creepster',
		'"Crete Round", serif' => 'Crete Round',
		'"Crimson Text", serif' => 'Crimson Text',
		'"Croissant One", sans-serif' => 'Croissant One',
		'"Crushed", sans-serif' => 'Crushed',
		'"Cuprum", sans-serif' => 'Cuprum',
		'"Cutive", serif' => 'Cutive',
		'"Cutive Mono", sans-serif' => 'Cutive Mono',
		'"Damion", sans-serif' => 'Damion',
		'"Dancing Script", sans-serif' => 'Dancing Script',
		'"Dangrek", sans-serif' => 'Dangrek',
		'"Dawning of a New Day", sans-serif' => 'Dawning of a New Day',
		'"Days One", sans-serif' => 'Days One',
		'"Delius", sans-serif' => 'Delius',
		'"Delius Swash Caps", sans-serif' => 'Delius Swash Caps',
		'"Delius Unicase", sans-serif' => 'Delius Unicase',
		'"Della Respira", serif' => 'Della Respira',
		'"Devonshire", sans-serif' => 'Devonshire',
		'"Didact Gothic", sans-serif' => 'Didact Gothic',
		'"Diplomata", sans-serif' => 'Diplomata',
		'"Diplomata SC", sans-serif' => 'Diplomata SC',
		'"Doppio One", sans-serif' => 'Doppio One',
		'"Dorsa", sans-serif' => 'Dorsa',
		'"Dosis", sans-serif' => 'Dosis',
		'"Dr Sugiyama", sans-serif' => 'Dr Sugiyama',
		'"Droid Sans", sans-serif' => 'Droid Sans',
		'"Droid Sans Mono", sans-serif' => 'Droid Sans Mono',
		'"Droid Serif", serif' => 'Droid Serif',
		'"Duru Sans", sans-serif' => 'Duru Sans',
		'"Dynalight", sans-serif' => 'Dynalight',
		'"EB Garamond", serif' => 'EB Garamond',
		'"Eagle Lake", sans-serif' => 'Eagle Lake',
		'"Eater", sans-serif' => 'Eater',
		'"Economica", sans-serif' => 'Economica',
		'"Electrolize", sans-serif' => 'Electrolize',
		'"Emblema One", sans-serif' => 'Emblema One',
		'"Emilys Candy", sans-serif' => 'Emilys Candy',
		'"Engagement", sans-serif' => 'Engagement',
		'"Englebert", sans-serif' => 'Englebert',
		'"Enriqueta", serif' => 'Enriqueta',
		'"Erica One", sans-serif' => 'Erica One',
		'"Esteban", serif' => 'Esteban',
		'"Euphoria Script", sans-serif' => 'Euphoria Script',
		'"Ewert", sans-serif' => 'Ewert',
		'"Exo", sans-serif' => 'Exo',
		'"Expletus Sans", sans-serif' => 'Expletus Sans',
		'"Fanwood Text", serif' => 'Fanwood Text',
		'"Fascinate", sans-serif' => 'Fascinate',
		'"Fascinate Inline", sans-serif' => 'Fascinate Inline',
		'"Faster One", sans-serif' => 'Faster One',
		'"Fasthand", sans-serif' => 'Fasthand',
		'"Federant", sans-serif' => 'Federant',
		'"Federo", sans-serif' => 'Federo',
		'"Felipa", sans-serif' => 'Felipa',
		'"Fenix", serif' => 'Fenix',
		'"Finger Paint", sans-serif' => 'Finger Paint',
		'"Fira Sans", sans-serif' => 'Fira Sans',
		'"Fjord One", serif' => 'Fjord One',
		'"Flamenco", sans-serif' => 'Flamenco',
		'"Flavors", sans-serif' => 'Flavors',
		'"Fondamento", sans-serif' => 'Fondamento',
		'"Fontdiner Swanky", sans-serif' => 'Fontdiner Swanky',
		'"Forum", sans-serif' => 'Forum',
		'"Francois One", sans-serif' => 'Francois One',
		'"Freckle Face", sans-serif' => 'Freckle Face',
		'"Fredericka the Great", sans-serif' => 'Fredericka the Great',
		'"Fredoka One", sans-serif' => 'Fredoka One',
		'"Freehand", sans-serif' => 'Freehand',
		'"Fresca", sans-serif' => 'Fresca',
		'"Frijole", sans-serif' => 'Frijole',
		'"Fugaz One", sans-serif' => 'Fugaz One',
		'"Gabriela", serif' => 'Gabriela',
		'"GFS Didot", sans-serif' => 'GFS Didot',
		'"GFS Neohellenic", sans-serif' => 'GFS Neohellenic',
		'"Gafata", sans-serif' => 'Gafata',
		'"Galdeano", sans-serif' => 'Galdeano',
		'"Galindo", sans-serif' => 'Galindo',
		'"Gentium Basic", serif' => 'Gentium Basic',
		'"Gentium Book Basic", serif' => 'Gentium Book Basic',
		'"Geo", sans-serif' => 'Geo',
		'"Geostar", sans-serif' => 'Geostar',
		'"Geostar Fill", sans-serif' => 'Geostar Fill',
		'"Germania One", sans-serif' => 'Germania One',
		'"Gilda Display", serif' => 'Gilda Display',
		'"Give You Glory", sans-serif' => 'Give You Glory',
		'"Glass Antiqua", sans-serif' => 'Glass Antiqua',
		'"Glegoo", serif' => 'Glegoo',
		'"Gloria Hallelujah", sans-serif' => 'Gloria Hallelujah',
		'"Goblin One", sans-serif' => 'Goblin One',
		'"Gochi Hand", sans-serif' => 'Gochi Hand',
		'"Gorditas", sans-serif' => 'Gorditas',
		'"Goudy Bookletter 1911", serif' => 'Goudy Bookletter 1911',
		'"Graduate", sans-serif' => 'Graduate',
		'"Gravitas One", sans-serif' => 'Gravitas One',
		'"Great Vibes", sans-serif' => 'Great Vibes',
		'"Griffy", sans-serif' => 'Griffy',
		'"Gruppo", sans-serif' => 'Gruppo',
		'"Gudea", sans-serif' => 'Gudea',
		'"Habibi", serif' => 'Habibi',
		'"Hammersmith One", sans-serif' => 'Hammersmith One',
		'"Hanalei", sans-serif' => 'Hanalei',
		'"Hanalei Fill", sans-serif' => 'Hanalei Fill',
		'"Handlee", sans-serif' => 'Handlee',
		'"Hanuman", sans-serif' => 'Hanuman',
		'"Happy Monkey", sans-serif' => 'Happy Monkey',
		'"Headland One", serif' => 'Headland One',
		'"Henny Penny", sans-serif' => 'Henny Penny',
		'"Herr Von Muellerhoff", sans-serif' => 'Herr Von Muellerhoff',
		'"Holtwood One SC", serif' => 'Holtwood One SC',
		'"Homemade Apple", sans-serif' => 'Homemade Apple',
		'"Homenaje", sans-serif' => 'Homenaje',
		'"IM Fell DW Pica", serif' => 'IM Fell DW Pica',
		'"IM Fell DW Pica SC", serif' => 'IM Fell DW Pica SC',
		'"IM Fell Double Pica", serif' => 'IM Fell Double Pica',
		'"IM Fell Double Pica SC", serif' => 'IM Fell Double Pica SC',
		'"IM Fell English", serif' => 'IM Fell English',
		'"IM Fell English SC", serif' => 'IM Fell English SC',
		'"IM Fell French Canon", serif' => 'IM Fell French Canon',
		'"IM Fell French Canon SC", serif' => 'IM Fell French Canon SC',
		'"IM Fell Great Primer", serif' => 'IM Fell Great Primer',
		'"IM Fell Great Primer SC", serif' => 'IM Fell Great Primer SC',
		'"Iceberg", sans-serif' => 'Iceberg',
		'"Iceland", sans-serif' => 'Iceland',
		'"Imprima", sans-serif' => 'Imprima',
		'"Inconsolata", sans-serif' => 'Inconsolata',
		'"Inder", sans-serif' => 'Inder',
		'"Indie Flower", sans-serif' => 'Indie Flower',
		'"Inika", serif' => 'Inika',
		'"Irish Grover", sans-serif' => 'Irish Grover',
		'"Istok Web", sans-serif' => 'Istok Web',
		'"Italiana", serif' => 'Italiana',
		'"Italianno", sans-serif' => 'Italianno',
		'"Jacques Francois", serif' => 'Jacques Francois',
		'"Jacques Francois Shadow", sans-serif' => 'Jacques Francois Shadow',
		'"Jim Nightshade", sans-serif' => 'Jim Nightshade',
		'"Jockey One", sans-serif' => 'Jockey One',
		'"Jolly Lodger", sans-serif' => 'Jolly Lodger',
		'"Josefin Sans", sans-serif' => 'Josefin Sans',
		'"Josefin Slab", serif' => 'Josefin Slab',
		'"Joti One", sans-serif' => 'Joti One',
		'"Judson", serif' => 'Judson',
		'"Julee", sans-serif' => 'Julee',
		'"Julius Sans One", sans-serif' => 'Julius Sans One',
		'"Junge", serif' => 'Junge',
		'"Jura", sans-serif' => 'Jura',
		'"Just Another Hand", sans-serif' => 'Just Another Hand',
		'"Just Me Again Down Here", sans-serif' => 'Just Me Again Down Here',
		'"Kameron", serif' => 'Kameron',
		'"Karla", sans-serif' => 'Karla',
		'"Kaushan Script", sans-serif' => 'Kaushan Script',
		'"Keania One", sans-serif' => 'Keania One',
		'"Kelly Slab", sans-serif' => 'Kelly Slab',
		'"Kenia", sans-serif' => 'Kenia',
		'"Khmer", sans-serif' => 'Khmer',
		'"Kite One", sans-serif' => 'Kite One',
		'"Knewave", sans-serif' => 'Knewave',
		'"Kotta One", serif' => 'Kotta One',
		'"Koulen", sans-serif' => 'Koulen',
		'"Kranky", sans-serif' => 'Kranky',
		'"Kreon", serif' => 'Kreon',
		'"Kristi", sans-serif' => 'Kristi',
		'"Krona One", sans-serif' => 'Krona One',
		'"La Belle Aurore", sans-serif' => 'La Belle Aurore',
		'"Lancelot", sans-serif' => 'Lancelot',
		'"Lato", sans-serif' => 'Lato',
		'"League Script", sans-serif' => 'League Script',
		'"Leckerli One", sans-serif' => 'Leckerli One',
		'"Ledger", serif' => 'Ledger',
		'"Lekton", sans-serif' => 'Lekton',
		'"Lemon", sans-serif' => 'Lemon',
		'"Life Savers", sans-serif' => 'Life Savers',
		'"Lilita One", sans-serif' => 'Lilita One',
		'"Limelight", sans-serif' => 'Limelight',
		'"Linden Hill", serif' => 'Linden Hill',
		'"Lobster", sans-serif' => 'Lobster',
		'"Lobster Two", sans-serif' => 'Lobster Two',
		'"Londrina Outline", sans-serif' => 'Londrina Outline',
		'"Londrina Shadow", sans-serif' => 'Londrina Shadow',
		'"Londrina Sketch", sans-serif' => 'Londrina Sketch',
		'"Londrina Solid", sans-serif' => 'Londrina Solid',
		'"Lora", serif' => 'Lora',
		'"Love Ya Like A Sister", sans-serif' => 'Love Ya Like A Sister',
		'"Loved by the King", sans-serif' => 'Loved by the King',
		'"Lovers Quarrel", sans-serif' => 'Lovers Quarrel',
		'"Luckiest Guy", sans-serif' => 'Luckiest Guy',
		'"Lusitana", serif' => 'Lusitana',
		'"Lustria", serif' => 'Lustria',
		'"Macondo", sans-serif' => 'Macondo',
		'"Macondo Swash Caps", sans-serif' => 'Macondo Swash Caps',
		'"Magra", sans-serif' => 'Magra',
		'"Maiden Orange", sans-serif' => 'Maiden Orange',
		'"Mako", sans-serif' => 'Mako',
		'"Marcellus", serif' => 'Marcellus',
		'"Marcellus SC", sans-serif' => 'Marcellus SC',
		'"Marck Script", sans-serif' => 'Marck Script',
		'"Margarine", sans-serif' => 'Margarine',
		'"Marko One", serif' => 'Marko One',
		'"Marmelad", sans-serif' => 'Marmelad',
		'"Marvel", sans-serif' => 'Marvel',
		'"Mate", serif' => 'Mate',
		'"Mate SC", serif' => 'Mate SC',
		'"Maven Pro", sans-serif' => 'Maven Pro',
		'"McLaren", sans-serif' => 'McLaren',
		'"Meddon", sans-serif' => 'Meddon',
		'"MedievalSharp", sans-serif' => 'MedievalSharp',
		'"Medula One", sans-serif' => 'Medula One',
		'"Megrim", sans-serif' => 'Megrim',
		'"Meie Script", sans-serif' => 'Meie Script',
		'"Merienda", sans-serif' => 'Merienda',
		'"Merienda One", sans-serif' => 'Merienda One',
		'"Merriweather", serif' => 'Merriweather',
		'"Metal", sans-serif' => 'Metal',
		'"Metal Mania", sans-serif' => 'Metal Mania',
		'"Metamorphous", sans-serif' => 'Metamorphous',
		'"Metrophobic", sans-serif' => 'Metrophobic',
		'"Michroma", sans-serif' => 'Michroma',
		'"Miltonian", sans-serif' => 'Miltonian',
		'"Miltonian Tattoo", sans-serif' => 'Miltonian Tattoo',
		'"Miniver", sans-serif' => 'Miniver',
		'"Miss Fajardose", sans-serif' => 'Miss Fajardose',
		'"Modern Antiqua", sans-serif' => 'Modern Antiqua',
		'"Molengo", sans-serif' => 'Molengo',
		'"Molle", sans-serif' => 'Molle',
		'"Monofett", sans-serif' => 'Monofett',
		'"Monoton", sans-serif' => 'Monoton',
		'"Monsieur La Doulaise", sans-serif' => 'Monsieur La Doulaise',
		'"Montaga", serif' => 'Montaga',
		'"Montez", sans-serif' => 'Montez',
		'"Montserrat", sans-serif' => 'Montserrat',
		'"Montserrat Alternates", sans-serif' => 'Montserrat Alternates',
		'"Montserrat Subrayada", sans-serif' => 'Montserrat Subrayada',
		'"Moul", sans-serif' => 'Moul',
		'"Moulpali", sans-serif' => 'Moulpali',
		'"Mountains of Christmas", sans-serif' => 'Mountains of Christmas',
		'"Mouse Memoirs", sans-serif' => 'Mouse Memoirs',
		'"Mr Bedfort", sans-serif' => 'Mr Bedfort',
		'"Mr Dafoe", sans-serif' => 'Mr Dafoe',
		'"Mr De Haviland", sans-serif' => 'Mr De Haviland',
		'"Mrs Saint Delafield", sans-serif' => 'Mrs Saint Delafield',
		'"Mrs Sheppards", sans-serif' => 'Mrs Sheppards',
		'"Muli", sans-serif' => 'Muli',
		'"Mystery Quest", sans-serif' => 'Mystery Quest',
		'"Neucha", sans-serif' => 'Neucha',
		'"Neuton", serif' => 'Neuton',
		'"News Cycle", sans-serif' => 'News Cycle',
		'"Niconne", sans-serif' => 'Niconne',
		'"Nixie One", sans-serif' => 'Nixie One',
		'"Nobile", sans-serif' => 'Nobile',
		'"Nokora", sans-serif' => 'Nokora',
		'"Norican", sans-serif' => 'Norican',
		'"Nosifer", sans-serif' => 'Nosifer',
		'"Nothing You Could Do", sans-serif' => 'Nothing You Could Do',
		'"Noticia Text", serif' => 'Noticia Text',
		'"Noto Sans", sans-serif' => 'Noto Sans',
		'"Noto Serif", serif' => 'Noto Serif',
		'"Nova Cut", sans-serif' => 'Nova Cut',
		'"Nova Flat", sans-serif' => 'Nova Flat',
		'"Nova Mono", sans-serif' => 'Nova Mono',
		'"Nova Oval", sans-serif' => 'Nova Oval',
		'"Nova Round", sans-serif' => 'Nova Round',
		'"Nova Script", sans-serif' => 'Nova Script',
		'"Nova Slim", sans-serif' => 'Nova Slim',
		'"Nova Square", sans-serif' => 'Nova Square',
		'"Numans", sans-serif' => 'Numans',
		'"Nunito", sans-serif' => 'Nunito',
		'"Odor Mean Chey", sans-serif' => 'Odor Mean Chey',
		'"Offside", sans-serif' => 'Offside',
		'"Old Standard TT", serif' => 'Old Standard TT',
		'"Oldenburg", sans-serif' => 'Oldenburg',
		'"Oleo Script", sans-serif' => 'Oleo Script',
		'"Oleo Script Swash Caps", sans-serif' => 'Oleo Script Swash Caps',
		'"Open Sans", sans-serif' => 'Open Sans',
		'"Open Sans Condensed", sans-serif' => 'Open Sans Condensed',
		'"Oranienbaum", serif' => 'Oranienbaum',
		'"Orbitron", sans-serif' => 'Orbitron',
		'"Oregano", sans-serif' => 'Oregano',
		'"Orienta", sans-serif' => 'Orienta',
		'"Original Surfer", sans-serif' => 'Original Surfer',
		'"Oswald", sans-serif' => 'Oswald',
		'"Over the Rainbow", sans-serif' => 'Over the Rainbow',
		'"Overlock", sans-serif' => 'Overlock',
		'"Overlock SC", sans-serif' => 'Overlock SC',
		'"Ovo", serif' => 'Ovo',
		'"Oxygen", sans-serif' => 'Oxygen',
		'"Oxygen Mono", sans-serif' => 'Oxygen Mono',
		'"Poppins", sans-serif' => 'Poppins',
		'"PT Mono", sans-serif' => 'PT Mono',
		'"PT Sans", sans-serif' => 'PT Sans',
		'"PT Sans Caption", sans-serif' => 'PT Sans Caption',
		'"PT Sans Narrow", sans-serif' => 'PT Sans Narrow',
		'"PT Serif", serif' => 'PT Serif',
		'"PT Serif Caption", serif' => 'PT Serif Caption',
		'"Pacifico", sans-serif' => 'Pacifico',
		'"Paprika", sans-serif' => 'Paprika',
		'"Parisienne", sans-serif' => 'Parisienne',
		'"Passero One", sans-serif' => 'Passero One',
		'"Passion One", sans-serif' => 'Passion One',
		'"Patrick Hand", sans-serif' => 'Patrick Hand',
		'"Patua One", sans-serif' => 'Patua One',
		'"Paytone One", sans-serif' => 'Paytone One',
		'"Peralta", sans-serif' => 'Peralta',
		'"Permanent Marker", sans-serif' => 'Permanent Marker',
		'"Petit Formal Script", sans-serif' => 'Petit Formal Script',
		'"Petrona", serif' => 'Petrona',
		'"Philosopher", sans-serif' => 'Philosopher',
		'"Piedra", sans-serif' => 'Piedra',
		'"Pinyon Script", sans-serif' => 'Pinyon Script',
		'"Pirata One", sans-serif' => 'Pirata One',
		'"Plaster", sans-serif' => 'Plaster',
		'"Play", sans-serif' => 'Play',
		'"Playball", sans-serif' => 'Playball',
		'"Playfair Display", serif' => 'Playfair Display',
		'"Playfair Display SC", serif' => 'Playfair Display SC',
		'"Podkova", serif' => 'Podkova',
		'"Poiret One", sans-serif' => 'Poiret One',
		'"Poller One", sans-serif' => 'Poller One',
		'"Poly", serif' => 'Poly',
		'"Pompiere", sans-serif' => 'Pompiere',
		'"Pontano Sans", sans-serif' => 'Pontano Sans',
		'"Port Lligat Sans", sans-serif' => 'Port Lligat Sans',
		'"Port Lligat Slab", serif' => 'Port Lligat Slab',
		'"Prata", serif' => 'Prata',
		'"Preahvihear", sans-serif' => 'Preahvihear',
		'"Press Start 2P", sans-serif' => 'Press Start 2P',
		'"Princess Sofia", sans-serif' => 'Princess Sofia',
		'"Prociono", serif' => 'Prociono',
		'"Prosto One", sans-serif' => 'Prosto One',
		'"Puritan", sans-serif' => 'Puritan',
		'"Purple Purse", sans-serif' => 'Purple Purse',
		'"Quando", serif' => 'Quando',
		'"Quantico", sans-serif' => 'Quantico',
		'"Quattrocento", serif' => 'Quattrocento',
		'"Quattrocento Sans", sans-serif' => 'Quattrocento Sans',
		'"Questrial", sans-serif' => 'Questrial',
		'"Quicksand", sans-serif' => 'Quicksand',
		'"Quintessential", sans-serif' => 'Quintessential',
		'"Qwigley", sans-serif' => 'Qwigley',
		'"Racing Sans One", sans-serif' => 'Racing Sans One',
		'"Radley", serif' => 'Radley',
		'"Raleway", sans-serif' => 'Raleway',
		'"Raleway Dots", sans-serif' => 'Raleway Dots',
		'"Rambla", sans-serif' => 'Rambla',
		'"Rammetto One", sans-serif' => 'Rammetto One',
		'"Ranchers", sans-serif' => 'Ranchers',
		'"Rancho", sans-serif' => 'Rancho',
		'"Rationale", sans-serif' => 'Rationale',
		'"Redressed", sans-serif' => 'Redressed',
		'"Reenie Beanie", sans-serif' => 'Reenie Beanie',
		'"Revalia", sans-serif' => 'Revalia',
		'"Ribeye", sans-serif' => 'Ribeye',
		'"Ribeye Marrow", sans-serif' => 'Ribeye Marrow',
		'"Righteous", sans-serif' => 'Righteous',
		'"Risque", sans-serif' => 'Risque',
		'"Roboto", sans-serif' => 'Roboto',
		'"Roboto Condensed", sans-serif' => 'Roboto Condensed',
		'"Roboto Mono", sans-serif' => 'Roboto Mono',
		'"Roboto Slab", serif' => 'Roboto Slab',
		'"Rochester", sans-serif' => 'Rochester',
		'"Rock Salt", sans-serif' => 'Rock Salt',
		'"Rokkitt", serif' => 'Rokkitt',
		'"Romanesco", sans-serif' => 'Romanesco',
		'"Ropa Sans", sans-serif' => 'Ropa Sans',
		'"Rosario", sans-serif' => 'Rosario',
		'"Rosarivo", serif' => 'Rosarivo',
		'"Rouge Script", sans-serif' => 'Rouge Script',
		'"Ruda", sans-serif' => 'Ruda',
		'"Rufina", serif' => 'Rufina',
		'"Ruge Boogie", sans-serif' => 'Ruge Boogie',
		'"Ruluko", sans-serif' => 'Ruluko',
		'"Rum Raisin", sans-serif' => 'Rum Raisin',
		'"Ruslan Display", sans-serif' => 'Ruslan Display',
		'"Russo One", sans-serif' => 'Russo One',
		'"Ruthie", sans-serif' => 'Ruthie',
		'"Rye", sans-serif' => 'Rye',
		'"Sacramento", sans-serif' => 'Sacramento',
		'"Sail", sans-serif' => 'Sail',
		'"Salsa", sans-serif' => 'Salsa',
		'"Sanchez", serif' => 'Sanchez',
		'"Sancreek", sans-serif' => 'Sancreek',
		'"Sansita One", sans-serif' => 'Sansita One',
		'"Sarina", sans-serif' => 'Sarina',
		'"Satisfy", sans-serif' => 'Satisfy',
		'"Scada", sans-serif' => 'Scada',
		'"Schoolbell", sans-serif' => 'Schoolbell',
		'"Seaweed Script", sans-serif' => 'Seaweed Script',
		'"Sevillana", sans-serif' => 'Sevillana',
		'"Seymour One", sans-serif' => 'Seymour One',
		'"Shadows Into Light", sans-serif' => 'Shadows Into Light',
		'"Shadows Into Light Two", sans-serif' => 'Shadows Into Light Two',
		'"Shanti", sans-serif' => 'Shanti',
		'"Share", sans-serif' => 'Share',
		'"Share Tech", sans-serif' => 'Share Tech',
		'"Share Tech Mono", sans-serif' => 'Share Tech Mono',
		'"Shojumaru", sans-serif' => 'Shojumaru',
		'"Short Stack", sans-serif' => 'Short Stack',
		'"Siemreap", sans-serif' => 'Siemreap',
		'"Sigmar One", sans-serif' => 'Sigmar One',
		'"Signika", sans-serif' => 'Signika',
		'"Signika Negative", sans-serif' => 'Signika Negative',
		'"Simonetta", sans-serif' => 'Simonetta',
		'"Sirin Stencil", sans-serif' => 'Sirin Stencil',
		'"Six Caps", sans-serif' => 'Six Caps',
		'"Skranji", sans-serif' => 'Skranji',
		'"Slabo 27px", serif' => 'Slabo 27px',
		'"Slackey", sans-serif' => 'Slackey',
		'"Smokum", sans-serif' => 'Smokum',
		'"Smythe", sans-serif' => 'Smythe',
		'"Sniglet", sans-serif' => 'Sniglet',
		'"Snippet", sans-serif' => 'Snippet',
		'"Snowburst One", sans-serif' => 'Snowburst One',
		'"Sofadi One", sans-serif' => 'Sofadi One',
		'"Sofia", sans-serif' => 'Sofia',
		'"Sonsie One", sans-serif' => 'Sonsie One',
		'"Sorts Mill Goudy", serif' => 'Sorts Mill Goudy',
		'"Source Code Pro", sans-serif' => 'Source Code Pro',
		'"Source Sans Pro", serif' => 'Source Sans Pro',
		'"Special Elite", sans-serif' => 'Special Elite',
		'"Spicy Rice", sans-serif' => 'Spicy Rice',
		'"Spinnaker", sans-serif' => 'Spinnaker',
		'"Spirax", sans-serif' => 'Spirax',
		'"Squada One", sans-serif' => 'Squada One',
		'"Stalemate", sans-serif' => 'Stalemate',
		'"Stalinist One", sans-serif' => 'Stalinist One',
		'"Stardos Stencil", sans-serif' => 'Stardos Stencil',
		'"Stint Ultra Condensed", sans-serif' => 'Stint Ultra Condensed',
		'"Stint Ultra Expanded", sans-serif' => 'Stint Ultra Expanded',
		'"Stoke", serif' => 'Stoke',
		'"Strait", sans-serif' => 'Strait',
		'"Sue Ellen Francisco", sans-serif' => 'Sue Ellen Francisco',
		'"Sunshiney", sans-serif' => 'Sunshiney',
		'"Supermercado One", sans-serif' => 'Supermercado One',
		'"Suwannaphum", sans-serif' => 'Suwannaphum',
		'"Swanky and Moo Moo", sans-serif' => 'Swanky and Moo Moo',
		'"Syncopate", sans-serif' => 'Syncopate',
		'"Tangerine", sans-serif' => 'Tangerine',
		'"Taprom", sans-serif' => 'Taprom',
		'"Telex", sans-serif' => 'Telex',
		'"Tenor Sans", sans-serif' => 'Tenor Sans',
		'"Text Me One", sans-serif' => 'Text Me One',
		'"The Girl Next Door", sans-serif' => 'The Girl Next Door',
		'"Tienne", serif' => 'Tienne',
		'"Tinos", serif' => 'Tinos',
		'"Titan One", sans-serif' => 'Titan One',
		'"Titillium Web", sans-serif' => 'Titillium Web',
		'"Trade Winds", sans-serif' => 'Trade Winds',
		'"Trocchi", serif' => 'Trocchi',
		'"Trochut", sans-serif' => 'Trochut',
		'"Trykker", serif' => 'Trykker',
		'"Tulpen One", sans-serif' => 'Tulpen One',
		'"Ubuntu", sans-serif' => 'Ubuntu',
		'"Ubuntu Condensed", sans-serif' => 'Ubuntu Condensed',
		'"Ubuntu Mono", sans-serif' => 'Ubuntu Mono',
		'"Ultra", serif' => 'Ultra',
		'"Uncial Antiqua", sans-serif' => 'Uncial Antiqua',
		'"Underdog", sans-serif' => 'Underdog',
		'"Unica One", sans-serif' => 'Unica One',
		'"UnifrakturCook", sans-serif' => 'UnifrakturCook',
		'"UnifrakturMaguntia", sans-serif' => 'UnifrakturMaguntia',
		'"Unkempt", sans-serif' => 'Unkempt',
		'"Unlock", sans-serif' => 'Unlock',
		'"Unna", serif' => 'Unna',
		'"VT323", sans-serif' => 'VT323',
		'"Vampiro One", sans-serif' => 'Vampiro One',
		'"Varela", sans-serif' => 'Varela',
		'"Varela Round", sans-serif' => 'Varela Round',
		'"Vast Shadow", sans-serif' => 'Vast Shadow',
		'"Vibur", sans-serif' => 'Vibur',
		'"Vidaloka", serif' => 'Vidaloka',
		'"Viga", sans-serif' => 'Viga',
		'"Voces", sans-serif' => 'Voces',
		'"Volkhov", serif' => 'Volkhov',
		'"Vollkorn", serif' => 'Vollkorn',
		'"Voltaire", sans-serif' => 'Voltaire',
		'"Waiting for the Sunrise", sans-serif' => 'Waiting for the Sunrise',
		'"Wallpoet", sans-serif' => 'Wallpoet',
		'"Walter Turncoat", sans-serif' => 'Walter Turncoat',
		'"Warnes", sans-serif' => 'Warnes',
		'"Wellfleet", sans-serif' => 'Wellfleet',
		'"Wire One", sans-serif' => 'Wire One',
		'"Yanone Kaffeesatz", sans-serif' => 'Yanone Kaffeesatz',
		'"Yellowtail", sans-serif' => 'Yellowtail',
		'"Yeseva One", sans-serif' => 'Yeseva One',
		'"Yesteryear", sans-serif' => 'Yesteryear',
		'"Zeyada", sans-serif' => 'Zeyada',
	) );

}


/* == enum == */


