<?php
/**
 * Hoot Theme files
 * This file is loaded after core theme's library/init and include/hoot-theme have loaded
 *
 * @package    Magazine News Byte
 * @subpackage Theme Premium
 */

/* Load theme includes. Must keep priority 10 for theme constants to be available. */
add_action( 'after_setup_theme', 'magnb_premium_includes', 10 );

/**
 * Loads the theme files supported by themes and template-related functions/classes. Functionality 
 * in these files should not be expected within the theme setup function.
 *
 * @since 1.0
 * @access public
 * @return void
 */
function magnb_premium_includes() {

	/* Load the Theme Specific HTML attributes */
	require_once( hoot_data()->premium_incdir . 'attr.php' );
	/* Load enqueue functions */
	require_once( hoot_data()->premium_incdir . 'enqueue.php' );
	/* Load the custom css functions */
	require_once( hoot_data()->premium_incdir . 'css.php' );
	/* Load the misc template functions. */
	require_once( hoot_data()->premium_incdir . 'template-helpers.php' );
	/* Load the google font functions. */
	require_once( hoot_data()->premium_incdir . 'admin/fonts.php' );
	/* Load Customizer Options Extend */
	require_once( hoot_data()->premium_incdir . 'admin/customizer-options.php' );
	/* Load Meta Options */
	require_once( hoot_data()->premium_incdir . 'admin/meta-options.php' );
	/* Load Megamenu Options */
	require_once( hoot_data()->premium_incdir . 'admin/megamenu.php' );
	/* Load the theme setup file */
	require_once( hoot_data()->premium_incdir . 'theme-setup.php' );

}

/**
 * Unload premium upsell/about page for premium themes
 *
 * @since 1.0
 * @access public
 * @param bool $load
 * @return bool
 */
function magnb_premium_unload_upsell( $load ) {
	return false;
}
$magnb_unload_upsell = apply_filters( 'magnb_unload_upsell', array( 'magnb_load_about', 'magnb_customize_load_trt' ) );
foreach ( $magnb_unload_upsell as $magnb_unload_hookname ) {
	add_filter( $magnb_unload_hookname, 'magnb_premium_unload_upsell' );
}

/**
 * Register OCDI Import Files
 * after_setup_theme is too late to hook into, hence added here
 *
 * @since 2.7
 * @return array
 */
function magnb_ocdi_import() {
	$files = array(
		array(
			'import_file_name'           => __( 'Magazine NewsByte Demo', 'magazine-news-byte-premium' ),
			'import_file_url'            => 'https://demo.wphoot.com/downloads/magazine-news-byte-content-free.xml',
			'import_widget_file_url'     => 'https://demo.wphoot.com/downloads/magazine-news-byte-widgets-free.wie',
			'import_customizer_file_url' => 'https://demo.wphoot.com/downloads/magazine-news-byte-customize-free.dat',
			'import_preview_image_url'   => hoot_data()->template_uri . 'screenshot.jpg',
			/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
			'import_notice'              => sprintf( esc_html__( 'You are using the free version of the theme.%1$sSome features (available only in the premium version) will not get imported - You may see %2$s"Could not import"%3$s message for these features in the log once the installation is finished. You can safely ignore these messages.', 'magazine-news-byte-premium' ), '<br />', '<em>', '</em>' ),
			'preview_url'                => 'https://demo.wphoot.com/magazine-news-byte/',
		),
	);
	if ( function_exists( 'hoot_lib_premium_core' ) ) {
		if ( isset( $files[0]['import_notice'] ) ) unset( $files[0]['import_notice'] );
		if ( isset( $files[0]['import_file_url'] ) ) $files[0]['import_file_url'] = str_replace( '-free', '', $files[0]['import_file_url'] );
		if ( isset( $files[0]['import_widget_file_url'] ) ) $files[0]['import_widget_file_url'] = str_replace( '-free', '', $files[0]['import_widget_file_url'] );
		if ( isset( $files[0]['import_customizer_file_url'] ) ) $files[0]['import_customizer_file_url'] = str_replace( '-free', '', $files[0]['import_customizer_file_url'] );
	}
	return $files;
}
add_filter( 'pt-ocdi/import_files', 'magnb_ocdi_import' );

/* Theme Premium Setup complete */
do_action( 'magnb_pemium_loaded' );