<?php
/**
 * Enqueue scripts and styles for the premium theme.
 * This file is loaded via the 'after_setup_theme' hook at priority '10'
 *
 * @package    Magazine News Byte
 * @subpackage Theme Premium
 */

/* Add custom scripts. */
add_action( 'wp_enqueue_scripts', 'magnb_premium_enqueue_scripts', 9 );

/* Set data for theme scripts localization. hootData is actually localized at priority 11, so populate data before that at priority 9 */
add_action( 'wp_enqueue_scripts', 'magnb_premium_localize_script', 9 );

/* Load theme premium script. Set priority to 11 so that the main script.js (@12) is loaded after, while other scripts are loaded before */
add_action( 'wp_enqueue_scripts', 'magnb_premium_base_enqueue_scripts', 11 );

/* Add custom styles. Set priority to default 10 so that theme's main style is loaded after these styles (at priority 11), and can thus easily override any style without over-qualification.  */
add_action( 'wp_enqueue_scripts', 'magnb_premium_enqueue_styles', 10 );

/**
 * Load scripts for the front end.
 *
 * @since 1.0
 * @access public
 * @return void
 */
function magnb_premium_enqueue_scripts() {

	/* Load lightGallery if 'light-gallery' or 'hoot-lightbox' is active. */
	if ( !hoot_get_mod('disable_lightbox') ) {
		$script_uri = hoot_locate_script( 'js/jquery.lightGallery' );
		wp_enqueue_script( 'jquery-lightGallery', $script_uri, array( 'jquery' ), '1.1.4', true );
	}

	/* Load isotope if needed */
	$archive_type = hoot_get_mod( 'archive_type' );
	// if ( is_home() || is_archive() ) // 'Blog' Widget may be used anywhere
	if ( $archive_type == 'mosaic2' || $archive_type == 'mosaic3' || $archive_type == 'mosaic4' ) {
		$script_uri = hoot_locate_script( 'js/jquery.isotope.pkgd' );
		wp_enqueue_script( 'jquery-isotope', $script_uri, array(), '2.1.1', true );
	}

}

/**
 * Set data for theme scripts localization
 *
 * @since 1.0
 * @access public
 * @return void
 */
function magnb_premium_localize_script() {

	$scriptdata = hoot_data( 'scriptdata' );
	if ( empty( $scriptdata ) )
		$scriptdata = array();

	// scrollpoints
	$padding = intval( hoot_get_mod( 'scrollpadding' ) );
	if ( !empty( $padding ) )
		$scriptdata['customScrollerPadding'] = $padding;

	// lightbox
	$scriptdata['lightbox'] = ( !hoot_get_mod( 'disable_lightbox' ) ) ? 'enable' : 'disable';
	// Disable Individual lightbox components (useful for child themes)
	// $scriptdata['lightboxImg'] = 'disable';
	if ( class_exists( 'Jetpack' ) && Jetpack::is_module_active( 'carousel' ) ) 
		$scriptdata['lightboxWpGal'] = 'disable';

	// lightGallery (added for brevity)
	$scriptdata['lightGallery'] = ( !hoot_get_mod( 'disable_lightbox' ) ) ? 'enable' : 'disable';

	// Isotope
	$scriptdata['isotope'] = 'enable';

	hoot_set_data( 'scriptdata', $scriptdata );

}

/**
 * Load scripts for the front end.
 *
 * @since 1.0
 * @access public
 * @return void
 */
function magnb_premium_base_enqueue_scripts() {

	// Load Theme Javascript (add dependency so premium is loaded after hoot-theme)
	$script_uri = hoot_locate_script( 'js/hoot.theme.premium' );
	wp_enqueue_script( 'hoot-theme-premium', $script_uri, array( 'hoot-theme' ), hoot_data()->template_version, true );

}

/**
 * Load stylesheets for the front end.
 *
 * @since 1.0
 * @access public
 * @return void
 */
function magnb_premium_enqueue_styles() {

	/* Load lightGallery style if 'light-gallery' or 'hoot-lightbox' is active. */
	if ( !hoot_get_mod('disable_lightbox') ) {
		$style_uri = hoot_locate_style( 'css/lightGallery' );
		wp_enqueue_style( 'lightGallery', $style_uri, false, '1.1.4' );
	}

}