<?php
/**
 * Add custom css to frontend.
 *
 * This file is loaded at 'after_setup_theme' hook with 10 priority.
 *
 * @package    Magazine News Byte
 * @subpackage Theme Premium
 */

/* Update user based style values for premium dynamic css */
add_filter( 'magnb_user_style', 'magnb_user_premium_style', 5 );

/* Modify lite theme CSS */
add_action( 'hoot_dynamic_cssrules', 'magnb_prepare_cssrules', 4 );

/* Add CSS built from premium options to the dynamic CSS array */
add_action( 'hoot_dynamic_cssrules', 'magnb_premium_dynamic_cssrules', 5 );

/* Add user input Custom CSS */
add_filter( 'hoot_dynamic_css', 'magnb_custom_user_css', 6, 2 );

/**
 * Create user based style values for premium dynamic css
 *
 * @since 1.0
 * @access public
 * @return array
 */
if ( !function_exists( 'magnb_user_premium_style' ) ) :
function magnb_user_premium_style( $styles ){

	/* Override Free styles */
	$styles['background_color']     = hoot_get_mod( 'background-color' ); // Override WordPress Custom Background

	/* Premium styles */
	$styles['topbar_color']             = hoot_get_mod( 'topbar_color' );
	$styles['font_body_face']           = hoot_get_mod( 'font_body-face' );
	$styles['font_body_color']          = hoot_get_mod( 'font_body-color' );
	$styles['font_body_size']           = hoot_get_mod( 'font_body-size' ); //##
	$styles['font_body_light']          = hoot_color_increase( $styles['font_body_color'], 37.5 ); // #fff => #9f9f9f , #000 => #606060, #777 => #aaa
	$styles['font_h3_size']             = hoot_get_mod( 'font_h3-size' );
	$styles['font_h3_face']             = hoot_get_mod( 'font_h3-face' );
	$styles['font_h4_size']             = hoot_get_mod( 'font_h4-size' );
	$styles['font_h5_size']             = hoot_get_mod( 'font_h5-size' );
	$styles['font_h6_size']             = hoot_get_mod( 'font_h6-size' );
	$styles['link_color']               = hoot_get_mod( 'link_color' );
	$styles['link_hover_color']         = hoot_get_mod( 'link_hover_color' );
	$styles['font_nav_menu_color']      = hoot_get_mod( 'font_nav_menu-color' );
	// $styles['font_nav_menu_face']       = hoot_get_mod( 'font_nav_menu-face' );
	$styles['below_header_color']       = hoot_get_mod( 'below_header_color' );
	$styles['topbar_background_type']   = hoot_get_mod( 'topbar_background_type' );
	$styles['topbar_background']        = hoot_get_mod( 'topbar_background' );
	$styles['header_background_type']   = hoot_get_mod( 'header_background_type' );
	$styles['header_background_color']  = hoot_get_mod( 'header_background-color' );
	$styles['logo_background_type']     = hoot_get_mod( 'logo_background_type' );
	$styles['logo_background']          = hoot_get_mod( 'logo_background' );
	$styles['menu_background_type']     = hoot_get_mod( 'menu_background_type' );
	$styles['menu_background']          = hoot_get_mod( 'menu_background' );
	$styles['menu_icons_color']         = hoot_get_mod( 'menu_icons_color' );
	$styles['menu_dropdown_background'] = hoot_get_mod( 'menu_dropdown_background' );
	$styles['below_header_background']  = hoot_get_mod( 'below_header_background' );
	$styles['pageheader_background']    = hoot_get_mod( 'pageheader_background' );
	$styles['footer_background_color']  = hoot_get_mod( 'footer_background-color' );
	$styles['font_footer_color']        = hoot_get_mod( 'font_footer-color' );
	// $styles['font_footer_dark']         = hoot_color_darken( $styles['font_footer_color'], 33 ); // #fff => #ababab, #000 => #000, #777 => #505050
	$styles['font_footer_light']        = hoot_color_increase( $styles['font_footer_color'], 25 ); // #fff => #bfbfbf , #000 => #404040, #777 => #999

	return $styles;
}
endif;

/**
 * Modify lite theme CSS if needed
 *
 * @since 1.0
 * @access public
 * @return void
 */
function magnb_prepare_cssrules() {

	$remove = array(
		'h1, h2, h3, h4, h5, h6, .title, .titlefont',
		'#site-title', '#site-description',
		'#header-supplementary',
		'#header-supplementary h1, #header-supplementary h2, #header-supplementary h3, #header-supplementary h4, #header-supplementary h5, #header-supplementary h6, #header-supplementary .title',
		'#header-supplementary .js-search .searchform.expand .searchtext',
		'#header-supplementary .js-search .searchform.expand .searchtext, #header-supplementary .js-search .searchform.expand .js-search-placeholder, .header-supplementary a, .header-supplementary a:hover',
		// '#header-supplementary .menu-items ul',
		'#header-supplementary .menu-items > li > a',
		'#header-supplementary .menu-items li.current-menu-item:not(.nohighlight), #header-supplementary .menu-items li.current-menu-ancestor, #header-supplementary .menu-items li:hover',
		'#header-supplementary .menu-items li.current-menu-item:not(.nohighlight) > a, #header-supplementary .menu-items li.current-menu-ancestor > a, #header-supplementary .menu-items li:hover > a',
		'.menu-items ul',
		// '.entry-footer .entry-byline', // remove so this comes after '.content .entry-byline' in premium css.php to override border-color value
	);

	global $hoot_style_builder;
	$hoot_style_builder->remove( $remove );

	$hoot_style_builder->remove_media( 'only screen and (max-width: 969px)', '#header-supplementary .mobilemenu-fixed .menu-toggle, #header-supplementary .mobilemenu-fixed .menu-items' );
	$hoot_style_builder->remove_media( 'only screen and (max-width: 969px)', '.mobilemenu-fixed .menu-toggle, .mobilemenu-fixed .menu-items' );
}

/**
 * Custom CSS built from user premium theme options
 * For proper sanitization, always use functions from hoot/includes/sanitization.php
 * and hoot/customizer/sanitization.php
 *
 * @since 1.0
 * @access public
 * @param array $cssrules array of css rules
 * @param array $vars misc option values
 * @return array
 */
function magnb_premium_dynamic_cssrules( $cssrules, $vars = array() ) {

	// Get user based style values
	$styles = magnb_user_style();
	extract( $styles );

	/*** Add Dynamic CSS ***/

	/* Base Typography and HTML */

	hoot_add_css_rule( array(
						'selector'  => 'body',
						'property'  => 'typography',
						'idtag'     => 'font_body',
					) );

	hoot_add_css_rule( array(
						'selector'         => 'h1, h2, h3, h4, h5, h6, .title',
						'property'         => 'typography',
						'idtag'            => 'font_h3',
						'typography_reset' => true,
					) );

	hoot_add_css_rule( array(
						'selector'         => 'h1',
						'property'         => 'typography',
						'idtag'            => 'font_h1',
						'typography_reset' => true,
					) );

	hoot_add_css_rule( array(
						'selector'         => 'h2',
						'property'         => 'typography',
						'idtag'            => 'font_h2',
						'typography_reset' => true,
					) );

	hoot_add_css_rule( array(
						'selector'         => 'h4',
						'property'         => 'typography',
						'idtag'            => 'font_h4',
						'typography_reset' => true,
					) );

	hoot_add_css_rule( array(
						'selector'         => 'h5',
						'property'         => 'typography',
						'idtag'            => 'font_h5',
						'typography_reset' => true,
					) );

	hoot_add_css_rule( array(
						'selector'         => 'h6',
						'property'         => 'typography',
						'idtag'            => 'font_h6',
						'typography_reset' => true,
					) );

	// Redundant: Already added above in 'h1, h2, h3, h4, h5, h6, .title' to use font_h3 typography
	// hoot_add_css_rule( array(
	// 					'selector'  => '.title',
	// 					'property'  => 'font-size',
	// 					'value'     => $font_h3_size,
	// 					'idtag'     => 'font_h3-size',
	// 				) );

	hoot_add_css_rule( array(
						'selector'  => '.titlefont',
						'property'  => 'font-family',
						'value'     => $font_h3_face,
						'idtag'     => 'font_h3-face',
					) );

	hoot_add_css_rule( array(
						'selector'  => 'blockquote',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'color'        => array( $font_body_light ),
							'font-size'    => array( $font_h6_size, 'font_h6-size' ),
							),
					) );

	hoot_add_css_rule( array(
						'selector'  => 'a',
						'property'  => 'color',
						'value'     => $link_color,
						'idtag'     => 'link_color',
					) ); // Overriding non premium dynamic css

	hoot_add_css_rule( array(
						'selector'  => 'a:hover',
						'property'  => 'color',
						'value'     => $link_hover_color,
						'idtag'     => 'link_hover_color',
					) ); // Overriding non premium dynamic css

	hoot_add_css_rule( array(
						'selector'  => '.invert-typo',
						'property'  => 'background',
						'value'     => $font_body_color,
						'idtag'     => 'font_body_color',
					) );

	hoot_add_css_rule( array(
						'selector'  => '.enforce-typo',
						'property'  => 'color',
						'value'     => $font_body_color,
						'idtag'     => 'font_body_color',
					) );

	hoot_add_css_rule( array(
						'selector'  => '.enforce-body-font',
						'property'  => 'font-family',
						'value'     => $font_body_face,
						'idtag'     => 'font_body-face',
					) );

	/* Images, WP Gallery and Objects */

	/* Layout */

	hoot_add_css_rule( array(
						'selector'  => 'body',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'background'   => array( '', 'background' ),
							),
					) );

	/* Header (Topbar, Header, Main Nav Menu) */
	// Topbar

	$topbar_background = ( $topbar_background_type == 'background' ) ? $topbar_background : 'none';
	hoot_add_css_rule( array(
						'selector'  => '#topbar',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'color'      => array( $topbar_color, 'topbar_color' ),
							'background' => array( $topbar_background, 'topbar_background' ),
							),
					) ); // Overriding non premium dynamic css

	if ( $topbar_background_type == 'background' ) {
		hoot_add_css_rule( array(
						'selector'  => '#topbar.js-search .searchform.expand .searchtext',
						'property'  => 'background',
						'value'     => $topbar_background,
						'idtag'     => 'topbar_background',
					) ); // Overriding non premium dynamic css
		hoot_add_css_rule( array(
						'selector'  => '#topbar.js-search .searchform.expand .searchtext' . ',' . '#topbar .js-search-placeholder',
						'property'  => 'color',
						'value'     => $topbar_color,
						'idtag'     => 'topbar_color',
					) ); // Overriding non premium dynamic css
	}

	/* Header (Topbar, Header, Main Nav Menu) */
	// Header Layout

	// $headerbg = ( $header_background_type == 'background' ) ? $header_background_color : $background_color;
	// if ( hoot_color( $headerbg, 'isdark', null ) )
	// 	hoot_add_css_rule( array(
	// 					'selector'  => '.header-aside-search .searchform',
	// 					'property'  => ' color ',
	// 					'value'     => 'rgba(255,255,255,0.5)',
	// 				) );

	if ( $header_background_type == 'background' ) {
		$headersearchtextcolor = ( hoot_color( $header_background_color, 'isdark', null ) ) ? '#ffffff' : '#333333';
		hoot_add_css_rule( array(
						'selector'  => '#header' . ',' . '#header-primary .js-search .searchform.expand .searchtext',
						'property'  => 'background',
						'idtag'     => 'header_background',
					) );
		hoot_add_css_rule( array(
						'selector'  => '#header-primary .js-search .searchform.expand .searchtext' . ',' . '#header-primary .js-search-placeholder',
						'property'  => 'color',
						'value'     => $headersearchtextcolor,
					) );
	} else {
		hoot_add_css_rule( array(
						'selector'  => '#header.stuck',
						'property'  => 'background',
						'idtag'     => 'background',
					) );
	}

	hoot_add_css_rule( array(
						'selector'  => '.site-boxed #header.stuck',
						'property'  => 'width',
						// 'value'     => ( intval( $grid_width ) - 30 ) . 'px', // @hgridMaxWidth - 2*@hgridSpanGutter
						'value'     => $grid_width,
						'idtag'     => 'grid_width',
						'media'     => 'only screen and (min-width: 970px)',
					) );

	/* Header (Topbar, Header, Main Nav Menu) */
	// Logo

	if ( $logo_background_type == 'background' ) {
		hoot_add_css_rule( array(
						'selector'  => '#site-logo',
						'property'  => 'background',
						'value'     => $logo_background,
						'idtag'     => 'logo_background',
					) );
	}

	hoot_add_css_rule( array(
						'selector'         => '#site-title' . ',' . '#site-logo.accent-typo #site-title', // Let logo typography options take effect even when inside accent bg
						'property'         => 'typography',
						'idtag'            => 'font_logo',
						'typography_reset' => true,
					) );

	hoot_add_css_rule( array(
						'selector'  => '#site-description' . ',' . '#site-logo.accent-typo #site-description', // Let logo typography options take effect even when inside accent bg
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'opacity'    => array( '1' ), // Reset styles from stylesheets
							'typography' => array( '', 'font_tagline', false, true ),
							),
					) );

	hoot_add_css_rule( array(
						'selector'  => '.site-title-body-font',
						'property'  => 'font-family',
						'value'     => $font_body_face,
						'idtag'     => 'font_body-face',
					) );

	hoot_add_css_rule( array(
						'selector'  => '.site-title-heading-font',
						'property'  => 'font-family',
						'value'     => $font_h3_face,
						'idtag'     => 'font_h3-face',
					) );

	/* Header (Topbar, Header, Main Nav Menu) */
	// Menu

	$menu_background = ( $menu_background_type == 'background' ) ? $menu_background : 'none';
	hoot_add_css_rule( array(
						'selector'  => '#header-aside.header-aside-menu' . ',' . '#header-supplementary',
						'property'  => 'background',
						'value'     => $menu_background,
					) );
	if ( $menu_background_type == 'background' ) {
		hoot_add_css_rule( array(
						'selector'  => '#header-supplementary' . ',' . '#header-aside.header-aside-menu',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'background' => array( $menu_background ),
							'color'      => array( $font_nav_menu_color ),
							),
					) ); // Enhanced from Lite
		hoot_add_css_rule( array(
						'selector'  => '#header-supplementary h1, #header-supplementary h2, #header-supplementary h3, #header-supplementary h4, #header-supplementary h5, #header-supplementary h6, #header-supplementary .title' . ',' . '#header-aside.header-aside-menu h1, #header-aside.header-aside-menu h2, #header-aside.header-aside-menu h3, #header-aside.header-aside-menu h4, #header-aside.header-aside-menu h5, #header-aside.header-aside-menu h6, #header-aside.header-aside-menu .title',
						'property'  => array(
							'color'  => 'inherit',
							'margin' => '0px',
							),
					) ); // Enhanced from Lite
		hoot_add_css_rule( array(
						'selector'  => '#header-supplementary .js-search .searchform.expand .searchtext' . ',' . '#header-aside.header-aside-menu .js-search .searchform.expand .searchtext',
						'property'  => 'background',
						'value'     => $menu_background,
					) ); // Enhanced from Lite
		hoot_add_css_rule( array(
						'selector'  => '#header-supplementary .js-search .searchform.expand .searchtext, #header-supplementary .js-search .searchform.expand .js-search-placeholder, .header-supplementary a, .header-supplementary a:hover' . ',' .
						//			   '#header-aside.header-aside-menu .js-search .searchform.expand .searchtext, #header-aside.header-aside-menu .js-search .searchform.expand .js-search-placeholder, .header-aside.header-aside-menu a, .header-aside.header-aside-menu a:hover',
									   '#header-aside.header-aside-menu .js-search .searchform.expand .searchtext, #header-aside.header-aside-menu .js-search .searchform.expand .js-search-placeholder, .header-aside-menu a, .header-aside-menu a:hover',
						'property'  => 'color',
						'value'     => 'inherit',
					) ); // Enhanced from Lite
		hoot_add_css_rule( array(
						'selector'  => '.menu-items li.current-menu-item:not(.nohighlight), .menu-items li.current-menu-ancestor, .menu-items li:hover',
						'property'  => 'background',
						'value'     => $accent_font,
						'idtag'     => 'accent_font',
					) ); // Enhanced from Lite - overriding in premium
		hoot_add_css_rule( array(
						'selector'  => '.menu-items li.current-menu-item:not(.nohighlight) > a, .menu-items li.current-menu-ancestor > a, .menu-items li:hover > a',
						'property'  => 'color',
						'value'     => $accent_color,
						'idtag'     => 'accent_color',
					) ); // Enhanced from Lite - overriding in premium
		hoot_add_css_rule( array(
						'selector'  => '.menu-side-box.js-search .searchform.expand .searchtext',
						'property'  => 'background',
						'value'     => $menu_background,
					) );
		hoot_add_css_rule( array(
						'selector'  => '.menu-side-box.js-search .searchform.expand .searchtext' . ',' . '.menu-side-box .js-search-placeholder',
						'property'  => 'color',
						'value'     => $font_nav_menu_color,
					) );
	}

	hoot_add_css_rule( array(
						'selector'         => '.menu-items > li > a' . ',' . '.menu-toggle' . ',' . '.menu-side-box', // .menu-side-box instead of div.menu-side-box so that font-size still remains small-font()
						'property'         => 'typography',
						'idtag'            => 'font_nav_menu',
						'typography_reset' => true,
					) );

	// hoot_add_css_rule( array(
	// 					'selector'         => '.menu-items .menu-title',
	// 					'property'         => 'font-family',
	// 					'value'            => $font_nav_menu_face,
	// 				) );

	hoot_add_css_rule( array(
						'selector'  => '.site-header .hoot-megamenu-icon',
						'property'  => 'color',
						'value'     => $menu_icons_color,
						'idtag'     => 'menu_icons_color',
					) );

	hoot_add_css_rule( array(
						'selector'         => '.menu-items ul a' . ',' . '.mobilemenu-fixed .menu-toggle'
												. ',' . '.mobilemenu-fixed .menu-toggle:hover', // added to override ".header-supplementary a, .header-supplementary a:hover" now since menu-toggle is <a> and not <div> for accessibility reasons
						'property'         => 'typography',
						'idtag'            => 'font_nav_dropdown',
						'typography_reset' => true,
					) );

	hoot_add_css_rule( array(
						'selector'  => '.menu-items ul',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'background'   => array( $menu_dropdown_background, 'menu_dropdown_background' ),
							),
					) );

	hoot_add_css_rule( array(
						'selector'         => '.menu-items > li > a',
						'property'         => 'typography',
						'idtag'            => 'font_nav_dropdown',
						// 'idtag'            => 'font_nav_menu', // when changing to font_nav_menu, ideally the color should still be of font_nav_dropdown as the background is set to $menu_dropdown_background
						'typography_reset' => true,
						'media'            => 'only screen and (max-width: 969px)',
					) );

	hoot_add_css_rule( array(
						'selector'  => '.mobilemenu-fixed .menu-toggle, .mobilemenu-fixed .menu-items' . ',' . '.menu-items',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'background'   => array( $menu_dropdown_background, 'menu_dropdown_background' ),
							),
						'media'     => 'only screen and (max-width: 969px)',
					) );

	/* Header (Topbar, Header, Main Nav Menu) */
	// Below Header

	hoot_add_css_rule( array(
						'selector'  => '#below-header',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'color'      => array( $below_header_color, 'below_header_color' ),
							'background' => array( $below_header_background, 'below_header_background' ),
							),
					) );
	hoot_add_css_rule( array(
						'selector'  => '#below-header.js-search .searchform.expand .searchtext',
						'property'  => 'background',
						'value'     => $below_header_background,
						'idtag'     => 'below_header_background',
					) );

	/* Main #Content */

	hoot_add_css_rule( array(
						'selector'  => '.main > .loop-meta-wrap.pageheader-bg-stretch, .main > .loop-meta-wrap.pageheader-bg-both' . ',' . '.content .loop-meta-wrap.pageheader-bg-incontent, .content .loop-meta-wrap.pageheader-bg-both',
						'property'  => 'background',
						'value'     => $pageheader_background,
						'idtag'     => 'pageheader_background',
					) );

	hoot_add_css_rule( array(
						'selector'         => '.loop-title',
						'property'         => 'typography',
						'idtag'            => 'font_h3',
						'typography_reset' => true,
					) );

	hoot_add_css_rule( array(
						'selector'         => '.content .loop-title',
						'property'         => 'typography',
						'idtag'            => 'font_h4',
						'typography_reset' => true,
					) );

	// hoot_add_css_rule( array(
	// 					'selector'  => '.entry-footer .entry-byline',
	// 					'property'  => 'color',
	// 					'value'     => $link_color,
	// 					'idtag'     => 'link_color',
	// 				) );

	hoot_add_css_rule( array( //##
						'selector'  => '.entry-the-content', //##
						'property'  => array( //##
							// property  => array( value, idtag, important, typography_reset ), //##
							'font-size'   => array( $font_body_size, 'font_body-size' ), //##
							'line-height' => array( 'inherit' ), //##
							), //##
					) ); //##

	hoot_add_css_rule( array(
						'selector'  => '#comments-number',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'color'     => array( $font_body_light ),
							),
					) );

	hoot_add_css_rule( array(
						'selector'  => '.comment-by-author' . ',' . '.comment-meta-block, .comment-edit-link',
						'property'  => 'color',
						'value'     => $font_body_light,
					) );

	/* Main #Content for Index (Archive / Blog List) */

	hoot_add_css_rule( array(
						'selector'         => '.entry-grid-content .entry-title',
						'property'         => 'typography',
						'idtag'            => 'font_h4',
						'typography_reset' => true,
					) );

	hoot_add_css_rule( array(
						'selector'  => '.archive-big .entry-grid-content .entry-title' . ',' . '.mixedunit-big .entry-grid-content .entry-title',
						'property'  => 'font-size',
						'value'     => ( (24/18) * intval( $font_h4_size ) ) . 'px', // $font_h2_size, // Get H2 size from H4 used for '.entry-grid-content .entry-title' above
						// 'idtag'     => 'font_h2-size',
					) );

	hoot_add_css_rule( array(
						'selector'         => '.archive-mosaic .entry-title',
						'property'         => 'typography',
						'idtag'            => 'font_h5',
						'typography_reset' => true,
					) );

	// hoot_add_css_rule( array(
	// 					'selector'  => '.entry-grid .more-link',
	// 					'property'  => 'font-family',
	// 					'value'     => $font_h3_face,
	// 					'idtag'     => 'font_h3-face',
	// 				) );

	/* Frontpage */

	/* Sidebars and Widgets */

	hoot_add_css_rule( array(
						// 'selector'         => '.sidebar',
						// Only focus main sidebar (exclude widget areas like header-side)
						'selector'         => '.main-content-grid .sidebar',
						'property'         => 'typography',
						'idtag'            => 'font_sidebar',
						'typography_reset' => true,
					) );

	// hoot_add_css_rule( array(
	// 					'selector'         => '.widget-title',
	// 					'property'         => 'typography',
	// 					'idtag'            => 'font_h4',
	// 					'typography_reset' => true,
	// 				) );

	hoot_add_css_rule( array(
						// 'selector'         => '.sidebar .widget-title',
						// Only focus main sidebar (exclude widget areas like header-side)
						'selector'         => '.main-content-grid .sidebar .widget-title',
						'property'         => 'typography',
						'idtag'            => 'font_sidebar_heading',
						'typography_reset' => true,
					) );

	hoot_add_css_rule( array(
						'selector'  => '.js-search .searchform.expand .searchtext' . ',' . '.js-search-placeholder',
						'property'  => 'color',
						'value'     => $font_body_color,
						'idtag'     => 'font_body_color',
					) );

	/* Third Party Plugins */

	hoot_add_css_rule( array(
						'selector'  => '.woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover',
						'property'  => 'color',
						'value'     => $link_hover_color,
						'idtag'     => 'link_hover_color',
					) ); // Overriding non premium dynamic css

	hoot_add_css_rule( array(
						'selector'         => '.woocommerce-tabs h1, .woocommerce-tabs h2, .woocommerce-tabs h3, .woocommerce-tabs h4, .woocommerce-tabs h5, .woocommerce-tabs h6' . ',' . '.single-product .upsells.products > h2, .single-product .related.products > h2, .singular-page.woocommerce-cart .cross-sells > h2, .singular-page.woocommerce-cart .cart_totals > h2',
						'property'         => 'typography',
						'idtag'            => 'font_h4',
						'typography_reset' => true,
					) );

	// hoot_add_css_rule( array(
	// 					'selector'  => '.widget_mailpoet_form .widget-title' . ',' . '.widget_newsletterwidget .widget-title, .widget_newsletterwidgetminimal .widget-title',
	// 					'property'  => 'font-size',
	// 					'value'     => $font_h3_size,
	// 					'idtag'     => 'font_h3-size',
	// 				) );

	/* Footer */

	hoot_add_css_rule( array(
						'selector'  => '.sub-footer' . ',' . '.footer',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'background'   => array( '', 'footer_background' ),
							'typography'   => array( '', 'font_footer', false, true ),
							),
					) );

	// hoot_add_css_rule( array(
	// 					'selector'  => '.footer h1, .footer h2, .footer h3, .footer h4, .footer h5, .footer h6, .footer .title',
	// 					'property'  => 'color',
	// 					'value'     => $font_footer_dark,
	// 				) );

	hoot_add_css_rule( array(
						'selector'         => '.sub-footer .widget-title, .footer .widget-title',
						'property'         => 'typography',
						'idtag'            => 'font_footer_heading',
						'typography_reset' => true,
					) );

	hoot_add_css_rule( array(
						'selector'  => '.post-footer',
						'property'  => array(
							'background'   => array( $footer_background_color ),
							'color'        => array( $font_footer_light ),
							),
					) );

}

/**
 * Add custom css rules added by user in Theme Options
 *
 * @since 1.0
 * @access public
 * @param string $css css string
 * @param array $vars misc option values
 * @return array
 */
function magnb_custom_user_css( $css, $vars = array() ) {

	$user_css = '';

	// Add Custom Post/Page CSS (include static page set as frontpage)
	if ( is_singular() ) {
		$page_css = hoot_get_metaoption( 'page_css' );
		$user_css .= ( !empty( $page_css ) ) ?  "\n" . $page_css : '';
	}

	// Add Custom CSS for page set as Blog Page
	if ( is_home() && !is_front_page() ) {
		$post_id = get_option( 'page_for_posts' );
		$page_css = hoot_get_metaoption( 'page_css', $post_id );
		$user_css .= ( !empty( $page_css ) ) ?  "\n" . $page_css : '';
	}

	// Add Custom CSS for page set as Shop Page
	if ( current_theme_supports( 'woocommerce' ) && is_shop() ) {
		$post_id = get_option( 'woocommerce_shop_page_id' );
		$page_css = hoot_get_metaoption( 'page_css', $post_id );
		$user_css .= ( !empty( $page_css ) ) ?  "\n" . $page_css : '';
	}

	// Allow child themes to modify and Return css string
	$user_css = apply_filters( 'magnb_custom_user_css', $user_css, $css, $vars );
	return $css . $user_css;
}