<?php
/**
 * Functions for sending list of google fonts.
 *
 * @package    Magazine News Byte
 * @subpackage Theme Premium
 */

/**
 * Get all google font families set by the user in theme options and return args to form enqueue url.
 * The theme should create google url using these args like so:
 * add_query_arg( $query_args, '//fonts.googleapis.com/css' );
 * @todo load only the required variants
 *
 * @since 2.9
 * @access public
 * @return array
 */
function magnb_premium_google_fonts_preparearray( $fonts ) {
	$hoot_customize = Hoot_Customize::get_instance();
	$settings = $hoot_customize->get_options('settings');
	$font_families = array();
	$fonts = array();

	foreach ( $settings as $id => $setting ) {
		if ( isset( $setting['type'] ) && 'fontface' == $setting['type'] ) {
			$value = hoot_get_mod( $id );
			if ( !empty( $value ) )
				$font_families[] = $value;
		}
	}
	$font_families = array_unique( $font_families );

	if ( !empty( $font_families ) ) {
		$fonts_list = hoot_enum_font_faces( 'google-fonts' );
		foreach ( $font_families as $cssstring => $font ) {
			if ( isset( $fonts_list[ $font ] ) ) {
				$fonts [ $fonts_list[ $font ] ] = array(
					'normal' => array( '300','400','500','600','700','800' ),
					'italic' => array( '400','700' ),
				);
			}
		}
	}

	return $fonts;
}
add_filter( 'magnb_google_fonts_preparearray', 'magnb_premium_google_fonts_preparearray' );

/**
 * Remove the filter added for lite version (to append fixed google fonts), and let those
 * fonts occur in their natural order as stated in hoot_googlefonts_list()
 *
 * Both /include/fonts.php and /premium/include/fonts.php are loaded at
 * after_setup_theme @priority 10. But since this file is loaded after /hoot-theme/fonts.php,
 * we dont need to hook it into any action.
 */
remove_filter( 'hoot_fonts_list', 'magnb_fonts_list' );