<?php
// Return if no vcards to show
if ( empty( $vcards ) || !is_array( $vcards ) )
	return;

// Get border classes
$top_class = hootkit_widget_borderclass( $border, 0, 'topborder-');
$bottom_class = hootkit_widget_borderclass( $border, 1, 'bottomborder-');

// Get total columns and set column counter
$columns = ( intval( $columns ) >= 1 && intval( $columns ) <= 5 ) ? intval( $columns ) : 3;
$column = $counter = 1;

// Set clearfix to avoid error if there are no boxes
$clearfix = 1;

// Set vars
$subtitle = ( !empty( $subtitle ) ) ? $subtitle : '';

// Template modification Hook
do_action( 'hootkit_vcards_wrap', ( ( !isset( $instance ) ) ? array() : $instance ) );
?>

<div class="vcards-widget-wrap <?php echo hoot_sanitize_html_classes( "{$top_class} {$bottom_class}" ); ?>">
	<div class="vcards-widget">

		<?php
		/* Display Title */
		$titlemarkup = $titleclass = '';
		if ( !empty( $title ) ) {
			$titlemarkup .= $before_title . $title . $after_title;
			$titleclass .= ' hastitle';
		}
		$titlemarkup = ( !empty( $titlemarkup ) ) ? '<div class="widget-title-wrap' . $titleclass . '">' . $titlemarkup . '</div>' : '';
		$titlemarkup .= ( !empty( $subtitle ) ) ? '<div class="widget-subtitle hoot-subtitle">' . $subtitle . '</div>' : '';
		echo do_shortcode( wp_kses_post( apply_filters( 'hootkit_widget_title', $titlemarkup, 'vcards', $title, $before_title, $after_title, $subtitle ) ) );

		// Template modification Hook
		do_action( 'hootkit_vcards_start', ( ( !isset( $instance ) ) ? array() : $instance ) );
		?>

		<div class="flush-columns">
			<?php
			foreach ( $vcards as $key => $vcard ) :

				// Set image
				if ( !empty( $vcard['image'] ) ) {
					// $default_img_size = apply_filters( 'hootkit_nohoot_vcard_imgsize', 'full' ) );
					$img_size = hootkit_thumbnail_size( 'column-1-' . $columns );
					$img_size = apply_filters( 'hootkit_vcard_imgsize', $img_size );
				}

				// Start Block Display
				if ( $column == 1 ) echo '<div class="vcard-row">';
				?>

				<div class="vcard-column <?php echo hoot_sanitize_html_classes( "hcolumn-1-{$columns} vcard-{$counter}" ); ?>">
					<div <?php hoot_attr( 'vcard', '', 'social-icons-invertx' ); ?>>

						<?php if ( !empty( $vcard['image'] ) ) : ?>
							<div class="vcard-visual vcard-image">
								<?php
								$imageid = intval( $vcard['image'] );
								if ( !empty( $imageid ) )
									echo wp_get_attachment_image( $imageid, $img_size, '', array( 'class' => "vcard-img attachment-{$img_size} size-{$img_size}", 'itemprop' => 'image' ) );
								?>
							</div>
						<?php endif; ?>

						<?php if ( !empty( $vcard['content'] ) ): ?>
							<div class="vcard-content <?php
								if ( !empty( $vcard['image'] ) ) echo 'vcard-content-hasimage';
								else echo 'no-visual';
								?>">
								<?php echo wp_kses_post( wpautop( $vcard['content'] ) ); ?>
							</div>
						<?php endif; ?>

						<?php
						// Display Profile Links
						$has_links = false;
						for ( $i=1; $i <= 5 ; $i++ ) { 
							if ( !empty( $vcard["url{$i}"] ) ) {
								$has_links = true;
								break;
							}
						}
						if ( $has_links ) : ?>
							<div class="vcard-links social-icons-widget social-icons-small">
								<?php
								for ( $i=1; $i <= 5 ; $i++ ) :
									if ( !empty( $vcard["url{$i}"] ) && !empty( $vcard["icon{$i}"] ) ) :
										echo '<div class="vcard-link">';

											// @NU
											if ( $vcard["icon{$i}"] == 'fa-skype' && function_exists( 'hootkit_get_skype_button' ) ) :
												echo '<div class="vcard-link-inner vcard-link-skype social-icons-icon fa-skype-block">'
													. '<i class="' . hoot_sanitize_fa( $vcard["icon{$i}"] ) . '"></i>'
													. hootkit_get_skype_button ( $vcard["url{$i}"] )
													. '</div>';
											else:

												$icon_class = sanitize_html_class( $vcard["icon{$i}"] ) . '-block social-icons-icon';
												$url = ( $vcard["icon{$i}"] == 'fa-envelope' ) ? 'mailto:' . antispambot( sanitize_email( $vcard["url{$i}"] ) ) : esc_url( $vcard["url{$i}"] );
												?><a href="<?php echo $url ?>" <?php hoot_attr( 'vcard-link-inner', $vcard["icon{$i}"], $icon_class ); ?>>
													<i class="<?php echo hoot_sanitize_fa( $vcard["icon{$i}"] ); ?>"></i>
												</a><?php

											endif;

										echo '</div>';
									endif;
								endfor;
								?>
							</div>
						<?php endif; ?>

					</div>
				</div>
				<?php

				$counter++;
				if ( $column == $columns ) {
					echo '</div>';
					$column = $clearfix = 1;
				} else {
					$clearfix = false;
					$column++;
				}

			endforeach;

			if ( !$clearfix ) echo '</div>';
			?>
		</div>

		<?php
		// Template modification Hook
		do_action( 'hootkit_vcards_end', ( ( !isset( $instance ) ) ? array() : $instance ) );
		?>

	</div>
</div>