<?php
/* Let developers alter slider via global $hoot_data */
do_action( 'hootkit_widgetcarousel_start', ( ( !isset( $instance ) ) ? array() : $instance ) );

/* Get Slider Data */
$slider = hoot_data( 'slider' );
if ( empty( $slider ) || !is_array( $slider ) )
	return;
$slidersettings = hoot_data( 'slidersettings' );
$slidersettings = ( empty( $slidersettings ) || !is_array( $slidersettings ) ) ? array() : $slidersettings;
$slidersettings['type'] = ( empty( $slidersettings['type'] ) ) ? '' : $slidersettings['type'];

/* Widget Class & Style */
$widgetclass = '';
if ( isset( $slidersettings['widgetclass'] ) ) {
	$widgetclass .= ' ' . hoot_sanitize_html_classes( $slidersettings['widgetclass'] );
	unset( $slidersettings['widgetclass'] );
}
$widgetstyle = '';
if ( isset( $slidersettings['widgetstyle'] ) ) {
	$widgetstyle .= 'style="' . esc_attr( $slidersettings['widgetstyle'] ) . '"';
	unset( $slidersettings['widgetstyle'] );
}

/* Manage Navigation */
$nav = empty( $nav ) ? 'both' : $nav;
if ( $nav == 'bullets' || $nav == 'none' ) $widgetclass .= ' hidearrows';
if ( $nav == 'arrows' || $nav == 'none' ) $widgetclass .= ' hidebullets';

/* Create Data attributes for javascript settings for this slider */
$atts = $class = '';
if ( isset( $slidersettings['id'] ) ) {
	$atts .= ' id="' . sanitize_html_class( $slidersettings['id'] ) . '"';
	unset( $slidersettings['id'] );
}
if ( isset( $slidersettings['class'] ) ) {
	$class .= ' ' . hoot_sanitize_html_classes( $slidersettings['class'] );
	unset( $slidersettings['class'] );
}
if ( isset( $slidersettings['item'] ) ) {
	$class .= ( $slidersettings['item'] == 1 ) ? ' singleSlideView' : ' multiSlideView';
}
foreach ( $slidersettings as $setting => $value )
	$atts .= ' data-' . sanitize_html_class( $setting ) . '="' . esc_attr( $value ) . '"';

/* Start Slider Template */
$slide_count = 1;

// Set vars
$subtitle = ( !empty( $subtitle ) ) ? $subtitle : '';
$viewall = ( !empty( $viewall ) ) ? $viewall : '';

?>
<div class="hootkitcarousel-widget<?php echo $widgetclass; ?>" <?php echo $widgetstyle ?>>

	<?php
	/* Display Title */
	$titlemarkup = $titleclass = '';
	if ( !empty( $title ) ) {
		$titlemarkup .= $before_title . $title . $after_title;
		$titleclass .= ' hastitle';
	}
	if ( $viewall == 'top' ) {
		$titleclass .= ' hasviewall';
		if ( $slidersettings['type'] == 'postcarousel' )
			$titlemarkup .= ( function_exists( 'hootkit_get_viewall' ) ) ? hootkit_get_viewall() : '';
		if ( $slidersettings['type'] == 'productcarousel' )
			$titlemarkup .= ( function_exists( 'hootkit_get_viewall' ) ) ? hootkit_get_viewall( false, 'product' ) : '';
	}
	$titlemarkup = ( !empty( $titlemarkup ) ) ? '<div class="widget-title-wrap' . $titleclass . '">' . $titlemarkup . '</div>' : '';
	$titlemarkup .= ( !empty( $subtitle ) ) ? '<div class="widget-subtitle hoot-subtitle">' . $subtitle . '</div>' : '';
	echo do_shortcode( wp_kses_post( apply_filters( 'hootkit_widget_title', $titlemarkup, 'carousel', $title, $before_title, $after_title, $subtitle, $viewall ) ) );

	// Template modification Hook
	do_action( 'hootkit_carousel_start', $slidersettings['type'], ( ( !isset( $instance ) ) ? array() : $instance ) );
	?>

	<ul class="lightSlider<?php echo $class; ?>"<?php echo $atts; ?>><?php
		foreach ( $slider as $key => $slide ) :

			$slide = wp_parse_args( $slide, array(
				'image'      => '',
				'title'      => '',
				'caption'    => '',
				'button'     => '',
				'url'        => '',
			) );
			$slide['image'] = intval( $slide['image'] );

			if ( !empty( $slide['image'] ) || !empty( $slide['title'] ) || !empty( $slide['caption'] ) ) :
				?>

				<li class="lightSlide hootkitcarousel hootkitcarousel-<?php echo $slide_count; $slide_count++; ?>">
					<div class="hootkitcarousel-slide">

						<?php if ( !empty( $slide['image'] ) ) : ?>
							<div class="hootkitcarousel-imgbox">
								<?php
								$img_size = 'hoot-preview-thumb';
								if ( !empty( $imagesize ) && $imagesize == 'rectangle' ) $img_size = 'hoot-medium-thumb';
								if ( !empty( $imagesize ) && $imagesize == 'full' ) $img_size = 'full';
								$img_size = apply_filters( 'hootkitcarousel_imgsize', $img_size );

								if ( !empty( $slide['url'] ) )
									echo '<a href="' . esc_url( $slide['url'] ) . '" ' . hoot_get_attr( 'hootkitcarousel-link' ) . '>';
								echo wp_get_attachment_image( $slide['image'], $img_size, '', array( 'class' => "hootkitcarousel-img attachment-{$img_size} size-{$img_size} skip-lazy", 'itemprop' => 'image' ) );
								if ( !empty( $slide['url'] ) )
									echo '</a>';
								?>
							</div>
						<?php endif; ?>

						<?php if ( !empty( $slide['title'] ) || !empty( $slide['caption'] ) ) : ?>
							<div <?php hoot_attr( 'hootkitcarousel-content' ) ?>>
								<?php
								if ( !empty( $slide['title'] ) )
									echo '<h6 class="hootkitcarousel-title">' . wp_kses_post( $slide['title'] ) . '</h6>';
								if ( !empty( $slide['meta'] ) )
									echo $slide['meta'];
								if ( !empty( $slide['caption'] ) )
									echo '<div class="hootkitcarousel-text">' . wp_kses_post( wpautop( $slide['caption'] ) ) . '</div>';
								if ( !empty( $slide['url'] ) && !empty( $slide['button'] ) )
									echo '<a href="' . esc_url( $slide['url'] ) . '" ' . hoot_get_attr( 'hootkitcarousel-link' ) . '>' . esc_html( $slide['button'] ) . '</a>';
								?>
							</div>
						<?php endif; ?>

					</div>
				</li>
				<?php
			endif;
		endforeach;
		?>
	</ul>

	<?php
	// View All link
	if ( $viewall == 'bottom' ) {
		if ( $slidersettings['type'] == 'postcarousel' )
			$titlemarkup .= ( function_exists( 'hootkit_get_viewall' ) ) ? hootkit_get_viewall( true ) : '';
		if ( $slidersettings['type'] == 'productcarousel' )
			$titlemarkup .= ( function_exists( 'hootkit_get_viewall' ) ) ? hootkit_get_viewall( true, 'product' ) : '';
	}

	// Template modification Hook
	do_action( 'hootkit_carousel_end', $slidersettings['type'], ( ( !isset( $instance ) ) ? array() : $instance ) );
	?>

</div>