<?php
// Set vars
$subtitle = ( !empty( $subtitle ) ) ? $subtitle : '';
?>

<div class="contact-info-widget">

	<?php
	/* Display Title */
	$titlemarkup = $titleclass = '';
	if ( !empty( $title ) ) {
		$titlemarkup .= $before_title . $title . $after_title;
		$titleclass .= ' hastitle';
	}
	$titlemarkup = ( !empty( $titlemarkup ) ) ? '<div class="widget-title-wrap' . $titleclass . '">' . $titlemarkup . '</div>' : '';
	$titlemarkup .= ( !empty( $subtitle ) ) ? '<div class="widget-subtitle hoot-subtitle">' . $subtitle . '</div>' : '';
	echo do_shortcode( wp_kses_post( apply_filters( 'hootkit_widget_title', $titlemarkup, 'contact-info', $title, $before_title, $after_title, $subtitle ) ) );
	?>

	<?php if ( !empty( $address ) ) : ?>
		<div class="contact-info-block content-info-home">
			<i <?php hoot_attr( 'contact-info-icon', 'address', 'fas fa-home' ) ?>></i>
			<div class="contact-info-text"><?php echo wp_kses_post( nl2br( $address ) ); ?></div>
		</div>
	<?php endif; ?>

	<?php if ( !empty( $phone ) ) : ?>
		<div class="contact-info-block content-info-phone">
			<i <?php hoot_attr( 'contact-info-icon', 'phone', 'fas fa-phone' ) ?>></i>
			<div class="contact-info-text"><a href="tel:<?php echo esc_attr( $phone ); ?>" <?php hoot_attr( 'contact-info-link', 'phone' ); ?>><?php echo $phone; ?></a></div>
		</div>
	<?php endif; ?>

	<?php if ( !empty( $email ) ) : ?>
		<div class="contact-info-block content-info-envelope">
			<i <?php hoot_attr( 'contact-info-icon', 'email', 'fas fa-envelope' ) ?>></i>
			<div class="contact-info-text"><a href="mailto:<?php echo antispambot( sanitize_email( $email ) ); ?>" <?php hoot_attr( 'contact-info-link', 'email' ); ?>><?php echo esc_html( $email ); ?></a></div>
		</div>
	<?php endif; ?>

	<?php
	if ( !empty( $profiles ) ) :
		foreach( $profiles as $key => $profile ) :
			$block_class = 'content-info-' . str_replace( 'fa-', '', sanitize_html_class( $profile['icon'] ) ); ?>
			<div class="contact-info-block <?php echo $block_class; ?>">

				<?php
				// @NU
				if ( $profile['icon'] == 'fa-skype' && function_exists( 'hootkit_get_skype_button' ) ) :
					echo '<div class="contact-info-skype fa-skype-block">'
						. '<i class="' . hoot_sanitize_fa( $profile['icon'] ) . '"></i>'
						. hootkit_get_skype_button ( $profile['url'] )
						. '</div>';
				else:

					$url = ( $profile['icon'] == 'fa-envelope' ) ? 'mailto:' . antispambot( sanitize_email( $profile['url'] ) ) : esc_url( $profile['url'] );
					$text = ( !empty( $profile['text'] ) ) ? $profile['text'] : $profile['url'];
					?>
					<i class="contact-info-icon <?php echo hoot_sanitize_fa( $profile['icon'] ); ?>"></i>
					<div class="contact-info-text"><?php
						if ( !empty( $url ) )
							echo '<a href="' . $url . '" ' . hoot_get_attr( 'contact-info-link', 'profile-' . esc_attr( $profile['icon'] ) ) . '>';
						if ( !empty( $text ) )
							echo esc_html( $text );
						if ( !empty( $url ) )
							echo '</a>';
						?>
					</div>
					<?php

				endif;
				?>

			</div>
			<?php
		endforeach;
	endif;
	?>

</div>