<?php
/**
 * Theme Manager Extension
 * This file is loaded at 'init' hook
 * This file is loaded only for is_admin()
 *
 * @package    Magazine News Byte
 * @subpackage Library Premium
 */

/**
 * Theme Manager class. This wraps everything up nicely.
 *
 * @since 3.0.0
 */
class Hoot_Manager_Export extends Hoot_Manager {

	/**
	 * Initialize everything
	 * 
	 * @since 3.0.0
	 * @access public
	 * @return void
	 */
	public function __construct() {

		/* Perform action and populate messages and admin page content */
		add_action( 'hoot_manager_page', array( $this, 'print_export' ) );

	}

	/**
	 * Print Theme Manager Page Content
	 *
	 * @since 3.0.0
	 */
	function print_export() {
		?>
		<div id="hoot-manager-export" class="hoot-manager">
			<h2><?php _e( 'Export Customizer Settings', 'magazine-news-byte-premium' ); ?></h2>
			<p><?php _e( 'Copy this code to export Customizer Settings for a particular theme<br /><em><strong>(only wphoot themes are displayed here)</strong></em>', 'magazine-news-byte-premium' ); ?></p>
			<?php
			$themes = $this->themes();
			$current = get_option( 'stylesheet' );
			foreach ( $themes as $theme_slug => $theme ) {
				$onlyhoot = apply_filters( 'hoot_exporter_onlyhoot', true );
				if ( !$onlyhoot ||
					 ( isset( $theme['author'] ) && stripos( $theme['author'], 'wphoot' ) !== false )
					 ) {
					$theme_name = ( !empty( $theme['name'] ) ) ? $theme['name'] : '';
					$mods = $this->theme_mods( $theme_slug, $theme_name );
					$iscurrent = ( $current == $theme_slug ) ? ' <span>' . __( 'Active Theme', 'magazine-news-byte-premium' ) . '</span>' : '';
					echo '<h4>' . $theme_name . $iscurrent . '</h4>';
					if ( !empty( $mods ) )
						echo '<textarea id="' . esc_attr( "hoot-$theme_slug" ) . '" class="hoot-manager-export-mod" name="hoot-manager-export[' . $theme_slug . ']" rows="3"  readonly="readonly" onclick="this.select()">' . esc_textarea( base64_encode( gzcompress( serialize ( $mods ) ) ) ) . '</textarea>';
					else
						echo '<p>' . __( 'No customizer settings available yet for this theme.', 'magazine-news-byte-premium' ) . '</p>';
				}
			}
			?>
		</div> <!-- .hoot-manager -->
		<?php
	}

	/**
	 * Get Themes
	 *
	 * @since 3.0.0
	 */
	function themes() {

		global $wp_themes;
		$return = array();

		if ( !empty( $wp_themes ) )
			$themes = $wp_themes;
		else
			$themes = wp_get_themes();

		if ( is_array( $themes ) && !empty( $themes ) ) {
			foreach ( $themes as $theme ) {
				$slug = $theme->get_stylesheet();
				$return[ $slug ][ 'name' ] = $theme->get('Name');
				$return[ $slug ][ 'author' ] = $theme->get('Author');
			}
		}
		return $return;

	}

	/**
	 * Get Theme Mods
	 *
	 * @since 3.0.0
	 */
	function theme_mods( $theme_slug, $theme_name = '' ) {
		$mods = get_option( "theme_mods_$theme_slug" ); // Theme Slug
		if ( false === $mods ) {
			$mods = get_option( "mods_$theme_name" ); // Theme Name // Deprecated location.
		}
		return $mods;
	}

}