jQuery(document).ready(function($) {
	"use strict";

	$('#menu-to-edit').on('sortstop', function( event, ui ) {

		var menuItem = ui.item.eq(0),
			menuItemUpdated = ui.placeholder.eq(0);

		if( menuItemUpdated.hasClass('menu-item-depth-0') )
			menuItem.find('p.hoot_top_level_only').show();
		else
			menuItem.find('p.hoot_top_level_only').hide();

	});

	$.fn.hootWidgetIconPicker = function() {
		return this.each(function(i,el) {
			var $self       = $(this);
			if ( $self.data('hoot-icon-setup') === true ) return true;
			else $self.data('hoot-icon-setup', true);

			var $picker_box = $self.siblings('.hoot-icon-picker-box'),
				$button     = $self.siblings('.hoot-icon-picked'),
				$preview    = $button.children('i'),
				$icons      = $picker_box.find('i');

			$button.on( "click", function() {
				$picker_box.toggleClass( 'hootshow' );
			});

			$icons.on( "click", function() {
				var iconvalue = $(this).data('value');
				$icons.removeClass('selected');
				var selected = ( ! $(this).hasClass('cmb-icon-none') ) ? 'selected' : '';
				$(this).addClass(selected);
				$preview.removeClass().addClass( selected + ' ' + iconvalue );
				$self.val(iconvalue);
				$self.trigger('change');
				$picker_box.removeClass( 'hootshow' );
			});

		});
	};

	$('#menu-to-edit .hoot-icon').hootWidgetIconPicker();
	// $('#menu-to-edit').bind("DOMNodeInserted",function(){
	// 	$('#menu-to-edit .hoot-icon').hootWidgetIconPicker();
	// });
	// console.log(wpNavMenu);
	$( document ).on('menu-item-added', function() {
		$('#menu-to-edit .hoot-icon').hootWidgetIconPicker();
	});

});