<?php
/**
 * Theme Setup
 * This file is loaded using 'after_setup_theme' hook at priority 10
 *
 * @package    Magazine News Byte
 * @subpackage Theme Premium
 */


/* === WordPress === */


// Remove theme support for backgrounds (handeled by custom control type in customize)
remove_theme_support( 'custom-background' );

// Make text widgets shortcode aware.
add_filter( 'widget_text', 'do_shortcode' );


/* === Hootkit Plugin === */


// Load theme's Hootkit functions if plugin is active
if ( class_exists( 'HootKit' ) && file_exists( hoot_data()->template_premium_dir . 'hootkit/functions.php' ) )
	include_once( hoot_data()->template_premium_dir . 'hootkit/functions.php' );


/* === Theme Setup Hooks === */


/**
 * Make HootKit Required plugin using TGMPA
 *
 * @since 1.0
 * @return array
 */
function magnb_premium_tgmpa_plugins( $plugins ) {
	foreach ( $plugins as $key => $plugin ) {
		if ( isset( $plugin['slug'] ) && $plugin['slug'] == 'hootkit' ) {
			$plugins[ $key ]['name'] = __( '(HootKit) Magazine NewsByte Premium Sliders, Widgets', 'magazine-news-byte-premium' );
			$plugins[ $key ]['required'] = true;
			break;
		}
	}
	return $plugins;
}
add_filter( 'magnb_tgmpa_plugins', 'magnb_premium_tgmpa_plugins' );

/**
 * Make theme specific premium background patterns available for loading into the options
 *
 * @since 1.0
 * @param array $patterns
 * @return array
 */
function magnb_background_pattern( $patterns ) {
	$default = array(
		0                                => hoot_data()->template_uri . 'images/patterns/0_preview.jpg',
		'images/patterns/1.png'          => hoot_data()->template_uri . 'images/patterns/1_preview.jpg',
		'images/patterns/2.png'          => hoot_data()->template_uri . 'images/patterns/2_preview.jpg',
		'images/patterns/3.png'          => hoot_data()->template_uri . 'images/patterns/3_preview.jpg',
		'images/patterns/4.png'          => hoot_data()->template_uri . 'images/patterns/4_preview.jpg',
		'images/patterns/5.png'          => hoot_data()->template_uri . 'images/patterns/5_preview.jpg',
		'images/patterns/6.png'          => hoot_data()->template_uri . 'images/patterns/6_preview.jpg',
		'images/patterns/7.png'          => hoot_data()->template_uri . 'images/patterns/7_preview.jpg',
		'images/patterns/8.png'          => hoot_data()->template_uri . 'images/patterns/8_preview.jpg',
		'premium/images/patterns/1.jpg'  => hoot_data()->template_premium_uri . 'images/patterns/1_preview.jpg',
		'premium/images/patterns/2.jpg'  => hoot_data()->template_premium_uri . 'images/patterns/2_preview.jpg',
		'premium/images/patterns/3.jpg'  => hoot_data()->template_premium_uri . 'images/patterns/3_preview.jpg',
		'premium/images/patterns/4.jpg'  => hoot_data()->template_premium_uri . 'images/patterns/4_preview.jpg',
		'premium/images/patterns/5.jpg'  => hoot_data()->template_premium_uri . 'images/patterns/5_preview.jpg',
		'premium/images/patterns/6.jpg'  => hoot_data()->template_premium_uri . 'images/patterns/6_preview.jpg',
		'premium/images/patterns/7.png'  => hoot_data()->template_premium_uri . 'images/patterns/7_preview.jpg',
		'premium/images/patterns/8.jpg'  => hoot_data()->template_premium_uri . 'images/patterns/8_preview.jpg',
		'premium/images/patterns/9.jpg'  => hoot_data()->template_premium_uri . 'images/patterns/9_preview.jpg',
		'premium/images/patterns/10.jpg' => hoot_data()->template_premium_uri . 'images/patterns/10_preview.jpg',
		'premium/images/patterns/11.jpg' => hoot_data()->template_premium_uri . 'images/patterns/11_preview.jpg',
		'premium/images/patterns/12.jpg' => hoot_data()->template_premium_uri . 'images/patterns/12_preview.jpg',
		'premium/images/patterns/13.jpg' => hoot_data()->template_premium_uri . 'images/patterns/13_preview.jpg',
		'premium/images/patterns/14.jpg' => hoot_data()->template_premium_uri . 'images/patterns/14_preview.jpg',
		'premium/images/patterns/15.jpg' => hoot_data()->template_premium_uri . 'images/patterns/15_preview.jpg',
		'premium/images/patterns/16.png' => hoot_data()->template_premium_uri . 'images/patterns/16_preview.jpg',
		'premium/images/patterns/17.jpg' => hoot_data()->template_premium_uri . 'images/patterns/17_preview.jpg',
		'premium/images/patterns/18.jpg' => hoot_data()->template_premium_uri . 'images/patterns/18_preview.jpg',
		'premium/images/patterns/19.jpg' => hoot_data()->template_premium_uri . 'images/patterns/19_preview.jpg',
		'premium/images/patterns/20.png' => hoot_data()->template_premium_uri . 'images/patterns/20_preview.jpg',
		'premium/images/patterns/21.png' => hoot_data()->template_premium_uri . 'images/patterns/21_preview.jpg',
		'premium/images/patterns/22.png' => hoot_data()->template_premium_uri . 'images/patterns/22_preview.jpg',
		'premium/images/patterns/23.jpg' => hoot_data()->template_premium_uri . 'images/patterns/23_preview.jpg',
		'premium/images/patterns/24.png' => hoot_data()->template_premium_uri . 'images/patterns/24_preview.jpg',
		'premium/images/patterns/25.jpg' => hoot_data()->template_premium_uri . 'images/patterns/25_preview.jpg',
		'premium/images/patterns/26.jpg' => hoot_data()->template_premium_uri . 'images/patterns/26_preview.jpg',
	);
	return array_merge( $patterns, $default );
}
add_filter( 'hoot_enum_background_pattern', 'magnb_background_pattern', 6 );

/**
 * Add Scroller Modules
 *
 * @since 1.0
 * @access public
 * @param array
	 * @return array
 */
function magnb_premium_scroller_modules( $modules ) {
	if ( !hoot_get_mod( 'disable_goto_top' ) )
		$modules[] = 'goto-top';
	if ( !hoot_get_mod( 'disable_sticky_header' ) )
		$modules[] = 'sticky-header';
	return $modules;
}
add_filter( 'hoot_scroller_modules', 'magnb_premium_scroller_modules' );