<?php
// Return if no boxes to show
if ( empty( $boxes ) || !is_array( $boxes ) )
	return;

// Get border classes
$top_class = hootkit_widget_borderclass( $border, 0, 'topborder-');
$bottom_class = hootkit_widget_borderclass( $border, 1, 'bottomborder-');

// Get total columns and set column counter
$columns = ( intval( $columns ) >= 1 && intval( $columns ) <= 5 ) ? intval( $columns ) : 3;
$column = $counter = 1;

// Set clearfix to avoid error if there are no boxes
$clearfix = 1;

// Create Data attributes for javascript settings for number visual
$size = empty( $size ) ? 'small' : $size;
$width = empty( $width ) ? 'thin' : $width;
switch ( $width ) {
	case 'medium':        $bwidth = 14; break;
	case 'heavy':         $bwidth = 18; break;
	case 'thin': default: $bwidth = 10; break;
}
$boxesatts = apply_filters( 'hootkit_number_block_default_atts', array(
	'foregroundcolor'       => hoot_get_mod( 'accent_color' ),
	'backgroundcolor'       => '#f5f5f5',
	'foregroundborderwidth' => $bwidth,
	'backgroundborderwidth' => $bwidth,
	'fontcolor'             => hoot_get_mod( 'font_body-color' ),
	'percent'               => 100,
	'animation'             => '1', // bug: 0 or '' dont work. instead input random integer like 'no' to stop animation
	'animationStep'         => 5,
	'percentageTextSize'    => 33,
	'textAdditionalCss'     => '',
), ( ( !isset( $instance ) ) ? array() : $instance ) );

// Set vars
$subtitle = ( !empty( $subtitle ) ) ? $subtitle : '';

// Template modification Hook
do_action( 'hootkit_number_blocks_wrap', ( ( !isset( $instance ) ) ? array() : $instance ) );
?>

<div class="number-blocks-widget-wrap <?php echo hoot_sanitize_html_classes( "{$top_class} {$bottom_class}" ); ?>">
	<div class="number-blocks-widget <?php echo 'number-blocks-' . sanitize_html_class( $size ); ?>">

		<?php
		/* Display Title */
		$titlemarkup = $titleclass = '';
		if ( !empty( $title ) ) {
			$titlemarkup .= $before_title . $title . $after_title;
			$titleclass .= ' hastitle';
		}
		$titlemarkup = ( !empty( $titlemarkup ) ) ? '<div class="widget-title-wrap' . $titleclass . '">' . $titlemarkup . '</div>' : '';
		$titlemarkup .= ( !empty( $subtitle ) ) ? '<div class="widget-subtitle hoot-subtitle">' . $subtitle . '</div>' : '';
		echo do_shortcode( wp_kses_post( apply_filters( 'hootkit_widget_title', $titlemarkup, 'number-blocks', $title, $before_title, $after_title, $subtitle ) ) );

		// Template modification Hook
		do_action( 'hootkit_number_blocks_start', ( ( !isset( $instance ) ) ? array() : $instance ) );
		?>

		<div class="flush-columns">
			<?php
			foreach ( $boxes as $key => $box ) :

				// Prepare Box Settings
				$box['number'] = intval( do_shortcode( $box['number'] ) );
				$box['percent'] = absint( do_shortcode( $box['percent'] ) );
				if ( empty( $box['percent'] ) || $box['percent'] > 100 ) $box['percent'] = 100;
				$showpercentsign = ( empty( $box['number'] ) );
				if ( empty( $box['number'] ) ) $box['number'] = $box['percent']; // Number will be empty if both number and percent are empty

				// Prepare Box Atts
				$atts = '';
				if ( !empty( $box['number'] ) ) {
					$boxatts = $boxesatts;
					$boxatts['percent'] = $box['percent'];
					$boxatts['display'] = $box['number'];
					$boxatts['displayprefix'] = !empty( $box['displayprefix'] ) ? $box['displayprefix'] : '';
					$boxatts['displaysuffix'] = !empty( $box['displaysuffix'] ) ? $box['displaysuffix'] : '';
					$boxatts['percentsign'] = ( $showpercentsign ) ? '%' : '';
					if ( !empty( $box['color'] ) ) $boxatts['foregroundcolor'] = $box['color'];

					$boxatts =  apply_filters( 'hootkit_number_block_atts', $boxatts, ( ( !isset( $instance ) ) ? array() : $instance ) );
					foreach ( $boxatts as $setting => $value )
						$atts .= ' data-' . $setting . '="' . esc_attr( $value ) . '"';
				}

				// Start Block Display
				if ( $column == 1 ) echo '<div class="number-block-row">';
				?>

				<div class="number-block-column <?php echo hoot_sanitize_html_classes( "hcolumn-1-{$columns} number-block-{$counter}" ); ?>">
					<div <?php hoot_attr( 'number-block' ); ?>>

						<?php if ( !empty( $box['number'] ) ) : ?>
							<div class="number-block-visual">
								<div class="number-block-circle" <?php echo $atts; ?>></div>
							</div>
						<?php endif; ?>

						<?php if ( !empty( $box['content'] ) ): ?>
							<div class="number-block-content <?php
								if ( !empty( $box['number'] ) ) echo 'number-block-content-hasvisual';
								else echo 'no-visual';
								?>">
								<?php echo wp_kses_post( wpautop( $box['content'] ) ); ?>
							</div>
						<?php endif; ?>

					</div>
				</div>
				<?php

				$counter++;
				if ( $column == $columns ) {
					echo '</div>';
					$column = $clearfix = 1;
				} else {
					$clearfix = false;
					$column++;
				}

			endforeach;

			if ( !$clearfix ) echo '</div>';
			?>
		</div>

		<?php
		// Template modification Hook
		do_action( 'hootkit_number_blocks_end', ( ( !isset( $instance ) ) ? array() : $instance ) );
		?>

	</div>
</div>