<?php
// Return if no button to show
if ( empty( $content ) && empty( $buttons ) )
	return;

// Get border classes
$top_class = hootkit_widget_borderclass( $border, 0, 'topborder-');
$bottom_class = hootkit_widget_borderclass( $border, 1, 'bottomborder-');

// Alignment
$align = ( !empty( $align ) ) ? 'buttons-' . esc_attr( $align ) : 'buttons-center';
?>

<div class="buttons-widget <?php echo hoot_sanitize_html_classes( "{$top_class} {$bottom_class} {$align}" ); ?>">

	<?php if ( !empty( $content ) ) { ?>
		<div class="buttons-precontent"><?php echo do_shortcode( wp_kses_post( wpautop( $content ) ) ); ?></div>
	<?php } ?>

	<?php if ( !empty( $buttons ) ) : ?>
		<div class="buttons-widget-group">
			<?php
			foreach ( $buttons as $key => $button ) {
				if ( !empty( $button['background'] ) || !empty( $button['fontcolor'] ) ) {
					$styleclass = 'buttonwidget-userstyle';
					$inlinestyle = ' style="';
					$inlinestyle .= ( $button['background'] ) ? 'background:' . sanitize_hex_color( $button['background'] ) . ';' : '';
					$inlinestyle .= ( $button['fontcolor'] ) ? 'color:' . sanitize_hex_color( $button['fontcolor'] ) . ';' : '';
					$inlinestyle .= '" ';
				} else $inlinestyle = $styleclass = '';
				echo '<a';
					echo ' href="' . esc_url( $button['url'] ) . '"';
					echo ' class="button-widget button button-order' . ( $key+1) .
								' button-' . sanitize_html_class( $size ) .
								' preset-' . sanitize_html_class( $button['preset'] ) .
								' ' . $styleclass .
								'" ';
					if ( !empty( $target ) ) echo ' target="_blank"';
					echo ' ' . $inlinestyle;
					echo '>';
				echo esc_html( $button['text'] );
				echo '</a>';
			}
			?>
		</div>
	<?php endif; ?>

</div>